/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.model.Achievement;
import java.time.Instant;

public class MatchTimerChecker
extends Checker {
    private Instant from;
    private Instant to;

    public MatchTimerChecker(CoreBox box) {
        super(box);
    }

    public void check(int amount, TimeUtils.Scale scale) {
        this.to = TimeUtils.currentInstant();
        this.from = TimeUtils.previousInstant(this.to, scale, amount);
        this.box.graph().activeMatches().stream().filter(m -> m.to() != null && TimeUtils.instantIsInRange(m.to(), this.from, this.to)).forEach(this::restartMatch);
    }

    private void restartMatch(Match match) {
        this.box.terminal().feed((GamificationEvent)EventBuilder.endMatch(match.worldId(), match.id()));
        if (match.reboot()) {
            this.box.terminal().feed((GamificationEvent)EventBuilder.beginMatch(match.worldId(), this.originalId(match), match.from(), match.to()));
            match.achievements().forEach(a -> {
                Achievement achievement = (Achievement)this.box.terminal().feed((GamificationEvent)EventBuilder.createAchievement(a, match.worldId()));
                achievement.progressIf(a.checker());
            });
        }
    }

    private String originalId(Match match) {
        return match.id().substring(0, match.id().indexOf("_"));
    }
}

