/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.AchievementChecker;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.checkers.MatchTimerChecker;
import io.intino.gamification.core.box.checkers.MissionChecker;
import io.intino.gamification.core.box.checkers.MissionTimerChecker;
import java.util.HashMap;
import java.util.Map;

public class Checkers {
    private final CoreBox box;
    private static Map<Class<? extends Checker>, Checker> builder = new HashMap<Class<? extends Checker>, Checker>();

    public Checkers(CoreBox box) {
        this.box = box;
        this.buildCheckers();
    }

    private void buildCheckers() {
        builder.put(AchievementChecker.class, new AchievementChecker(this.box));
        builder.put(MissionChecker.class, new MissionChecker(this.box));
        builder.put(MatchTimerChecker.class, new MatchTimerChecker(this.box));
        builder.put(MissionTimerChecker.class, new MissionTimerChecker(this.box));
    }

    public <T extends Checker> T checker(Class<T> clazz) {
        return (T)builder.get(clazz);
    }
}

