/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.checkers.CheckResult;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.Player;
import java.util.HashMap;
import java.util.Map;

public class CheckerHandler {
    private static final Map<String, Checker<? extends GamificationEvent>> AchievementCheckerMap = new HashMap<String, Checker<? extends GamificationEvent>>();
    private static final Map<String, Checker<? extends GamificationEvent>> MissionCheckerMap = new HashMap<String, Checker<? extends GamificationEvent>>();

    public static <T extends GamificationEvent> CheckResult check(Achievement achievement, T event, Player player) {
        try {
            Checker<? extends GamificationEvent> checker = AchievementCheckerMap.get(achievement.id());
            return checker.check(event, player);
        }
        catch (ClassCastException | NullPointerException e) {
            return CheckResult.Skip;
        }
    }

    public static <T extends GamificationEvent> CheckResult check(Mission mission, T event, Player player) {
        try {
            Checker<? extends GamificationEvent> checker = MissionCheckerMap.get(mission.id());
            return checker.check(event, player);
        }
        catch (ClassCastException | NullPointerException e) {
            return CheckResult.Skip;
        }
    }

    public static <T extends GamificationEvent> void progressIf(Achievement achievement, Checker<T> checker) {
        AchievementCheckerMap.put(achievement.id(), checker);
    }

    public static <T extends GamificationEvent> void progressIf(Mission mission, Checker<T> checker) {
        MissionCheckerMap.put(mission.id(), checker);
    }

    public static Checker<? extends GamificationEvent> checkerOf(Achievement achievement) {
        return AchievementCheckerMap.get(achievement.id());
    }

    public static interface Checker<T> {
        public CheckResult check(T var1, Player var2);
    }
}

