/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.CheckResult;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.checkers.entries.AchievementEntry;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.helper.AchievementStateHelper;
import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.model.attributes.AchievementState;
import io.intino.gamification.core.model.attributes.AchievementType;
import java.util.List;

public class AchievementChecker
extends Checker {
    public AchievementChecker(CoreBox box) {
        super(box);
    }

    public void checkAchievements(GamificationEvent event) {
        List<AchievementEntry> achievementEntries = this.box.graph().achievement(event.getClass());
        achievementEntries.forEach(ae -> ae.players().forEach(p -> this.checkAchievement(event, ae.achievement(), ae.type(), ae.context(), (Player)p)));
    }

    private void checkAchievement(GamificationEvent event, Achievement achievement, AchievementType type, String contextId, Player player) {
        CheckResult checkResult = achievement.check(event, player);
        if (checkResult == CheckResult.Skip) {
            return;
        }
        io.intino.gamification.core.graph.AchievementState achievementState = this.box.helper(AchievementStateHelper.class).getOrCreateAchievementState(achievement, type, contextId, player);
        if (checkResult == CheckResult.Progress) {
            achievementState.count(achievementState.count() + 1).save$();
            if (achievementState.count() >= achievement.maxCount()) {
                this.box.terminal().feed((GamificationEvent)EventBuilder.newStateAchievement(achievement.id(), contextId, player.id(), AchievementState.Achieved, type));
            }
        } else if (checkResult == CheckResult.Cancel) {
            this.box.terminal().feed((GamificationEvent)EventBuilder.newStateAchievement(achievement.id(), contextId, player.id(), AchievementState.Failed, type));
        }
    }
}

