/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box;

import io.intino.alexandria.core.Box;
import io.intino.gamification.api.EngineConfiguration;
import io.intino.gamification.api.EngineDatamart;
import io.intino.gamification.api.EngineTerminal;
import io.intino.gamification.core.box.AbstractBox;
import io.intino.gamification.core.box.CoreConfiguration;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.checkers.Checkers;
import io.intino.gamification.core.box.events.Terminal;
import io.intino.gamification.core.box.helper.Helper;
import io.intino.gamification.core.box.helper.Helpers;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.Mounters;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.magritte.framework.Graph;
import java.io.File;

public class CoreBox
extends AbstractBox {
    private CoreGraph graph;
    private Terminal terminal;
    private EngineConfiguration engineConfig;
    private EngineTerminal engineTerminal;
    private EngineDatamart engineDatamart;
    private Mounters mounters;
    private Checkers checkers;
    private Helpers helpers;
    private final File datamartFile;

    public CoreBox(String[] args) {
        this(new CoreConfiguration(args));
    }

    public CoreBox(CoreConfiguration configuration) {
        super(configuration);
        TimeUtils.TIME_ZONE = configuration.timeZone();
        this.datamartFile = new File(configuration.datamartPath());
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(CoreGraph.class);
        }
        return this;
    }

    @Override
    public void beforeStart() {
        this.engineConfig = new EngineConfiguration(this);
        if (this.graph != null) {
            this.graph.engineConfig(this.engineConfig);
        }
        this.terminal = new Terminal(this);
        this.engineTerminal = new EngineTerminal(this);
        this.engineDatamart = new EngineDatamart(this);
        this.mounters = new Mounters(this);
        this.checkers = new Checkers(this);
        this.helpers = new Helpers(this);
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    public File datamart() {
        return this.datamartFile;
    }

    public CoreGraph graph() {
        return this.graph;
    }

    public Terminal terminal() {
        return this.terminal;
    }

    public EngineConfiguration engineConfig() {
        return this.engineConfig;
    }

    public EngineTerminal engineTerminal() {
        return this.engineTerminal;
    }

    public EngineDatamart engineDatamart() {
        return this.engineDatamart;
    }

    public <L extends Mounter> L mounter(Class<L> clazz) {
        return this.mounters.mounter(clazz);
    }

    public <L extends Checker> L checker(Class<L> clazz) {
        return this.checkers.checker(clazz);
    }

    public <L extends Helper> L helper(Class<L> clazz) {
        return this.helpers.helper(clazz);
    }
}

