/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.api;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.model.Achievement;
import io.intino.gamification.core.model.Item;
import io.intino.gamification.core.model.Match;
import io.intino.gamification.core.model.Mission;
import io.intino.gamification.core.model.Npc;
import io.intino.gamification.core.model.Player;
import io.intino.gamification.core.model.World;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EngineDatamart {
    private final CoreBox box;

    public EngineDatamart(CoreBox box) {
        this.box = box;
    }

    public void clear() {
        this.box.graph().clear();
    }

    public World world(String id) {
        return Optional.ofNullable(this.box.graph().world(id)).map(World::new).orElse(null);
    }

    public List<World> worlds() {
        return this.box.graph().worldList().stream().map(World::new).collect(Collectors.toList());
    }

    public Match match(String worldId) {
        return Optional.ofNullable(this.box.graph().world(worldId)).map(w -> new Match(w.match())).orElse(null);
    }

    public Player player(String worldId, String id) {
        return this.players(worldId).stream().filter(p -> p.id().equals(id)).findFirst().orElse(null);
    }

    public List<Player> players(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::players).orElse(new ArrayList());
    }

    public Npc npc(String worldId, String id) {
        return this.npcs(worldId).stream().filter(n -> n.id().equals(id)).findFirst().orElse(null);
    }

    public List<Npc> npcs(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::npcs).orElse(new ArrayList());
    }

    public Item item(String worldId, String id) {
        return this.items(worldId).stream().filter(i -> i.id().equals(id)).findFirst().orElse(null);
    }

    public List<Item> items(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::items).orElse(new ArrayList());
    }

    public Mission mission(String worldId, String id) {
        return this.missions(worldId).stream().filter(m -> m.id().equals(id)).findFirst().orElse(null);
    }

    public List<Mission> missions(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::match).map(Match::missions).orElse(new ArrayList());
    }

    public List<Mission> activeMissions(String worldId) {
        Instant now = TimeUtils.currentInstant();
        return this.missions(worldId).stream().filter(m -> now.isBefore(m.expiration())).collect(Collectors.toList());
    }

    public Achievement globalAchievement(String worldId, String id) {
        return this.globalAchievements(worldId).stream().filter(a -> a.id().equals(id)).findFirst().orElse(null);
    }

    public Achievement localAchievement(String worldId, String id) {
        return this.localAchievements(worldId).stream().filter(a -> a.id().equals(id)).findFirst().orElse(null);
    }

    public List<Achievement> globalAchievements(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::achievements).orElse(new ArrayList());
    }

    public List<Achievement> localAchievements(String worldId) {
        return Optional.ofNullable(this.world(worldId)).map(World::match).map(Match::achievements).orElse(new ArrayList());
    }
}

