/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.api;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.configurator.GameLoopConfigurator;
import io.intino.gamification.core.box.listeners.EntityAttributeListener;
import io.intino.gamification.core.box.mappers.MissionScoreMapper;
import io.intino.gamification.core.box.mappers.PlayerLevelMapper;
import io.intino.gamification.core.graph.Entity;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.model.attributes.MissionState;

public class EngineConfiguration {
    private final CoreBox box;
    public final GameLoopConfigurator gameLoopConfigurator;
    public final Variable<PlayerLevelMapper> playerLevelMapper = new Variable<PlayerLevelMapper>(EngineConfiguration::playerLevelMapper);
    public final Variable<MissionScoreMapper> missionScoreMapper = new Variable<MissionScoreMapper>(EngineConfiguration::missionScoreMapper);
    public final Variable<EntityAttributeListener<Double>> healthListener = new Variable<EntityAttributeListener<Double>>(EngineConfiguration::healthListener);
    public final Variable<EntityAttributeListener<Integer>> scoreListener = new Variable<EntityAttributeListener<Integer>>(EngineConfiguration::scoreListener);
    public final Variable<EntityAttributeListener<Boolean>> enableListener = new Variable<EntityAttributeListener<Boolean>>(EngineConfiguration::enableListener);

    public EngineConfiguration(CoreBox box) {
        this.box = box;
        this.gameLoopConfigurator = new GameLoopConfigurator(box);
    }

    private static int playerLevelMapper(Player player, int score) {
        return Math.toIntExact(Math.max(1L, Math.round(5.7 * Math.log(Math.max(score, 1)) - 24.5)));
    }

    private static int missionScoreMapper(Player player, Mission mission, MissionState state) {
        return Math.round(100.0f * mission.difficulty().multiplier() * mission.type().multiplier() * state.multiplier());
    }

    private static Double healthListener(Entity entity, Double oldValue, Double newValue) {
        return newValue;
    }

    private static Integer scoreListener(Entity entity, Integer oldValue, Integer newValue) {
        return newValue;
    }

    private static Boolean enableListener(Entity entity, Boolean oldValue, Boolean newValue) {
        return newValue;
    }

    public static final class Variable<T> {
        private T value;

        public Variable() {
            this(null);
        }

        public Variable(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public T getOrDefault(T defaultValue) {
            return this.value != null ? this.value : defaultValue;
        }

        public void set(T value) {
            this.value = value;
        }
    }
}

