/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification;

import io.intino.alexandria.core.BoxConfiguration;
import io.intino.alexandria.logger.Logger;
import io.intino.gamification.api.EngineConfiguration;
import io.intino.gamification.api.EngineDatamart;
import io.intino.gamification.api.EngineTerminal;
import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.launcher.Launcher;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GamificationEngine {
    private final Launcher launcher;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private CoreBox box;

    public GamificationEngine(BoxConfiguration configuration) {
        this(configuration.args());
    }

    public GamificationEngine(Map<String, String> arguments) {
        this.launcher = new Launcher(arguments);
    }

    public void launch() {
        this.launch(() -> {});
        this.waitFor();
    }

    public void launch(Runnable onStartCallback) {
        this.launcher.onStart(() -> {
            this.box = this.launcher.box();
            onStartCallback.run();
            this.countDownLatch.countDown();
        });
        this.launcher.start();
    }

    public void waitFor() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    public void waitFor(long timeout, TimeUnit timeUnit) {
        try {
            this.countDownLatch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    public EngineConfiguration configuration() {
        return this.box.engineConfig();
    }

    public EngineTerminal terminal() {
        return this.box.engineTerminal();
    }

    public EngineDatamart datamart() {
        return this.box.engineDatamart();
    }
}

