/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public interface ZetStream {
    public long current();

    public long next();

    public boolean hasNext();

    default public Iterator<Long> asIterator() {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return ZetStream.this.hasNext();
            }

            @Override
            public Long next() {
                return ZetStream.this.next();
            }
        };
    }

    public static class ZetStreamWithIndex {
        private final ZetStream stream;
        private final int index;

        public ZetStreamWithIndex(ZetStream stream, int index) {
            this.stream = stream;
            this.index = index;
        }
    }

    public static class Empty
    implements ZetStream {
        public static final ZetStream instance = new Empty();

        @Override
        public long current() {
            return -1L;
        }

        @Override
        public long next() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }

    public static class Merge
    implements ZetStream {
        private final List<ZetStream> streams;
        private long current;
        private long next;

        public Merge(List<ZetStream> streams) {
            this.streams = streams;
            this.current = -1L;
            this.streams.forEach(ZetStream::next);
            this.next = this.nextValue();
        }

        public Merge(ZetStream ... streams) {
            this(Arrays.asList(streams));
        }

        @Override
        public long current() {
            return this.current;
        }

        @Override
        public long next() {
            this.current = this.next;
            this.next = this.nextValue();
            return this.current;
        }

        private long nextValue() {
            int index = -1;
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.streams.size(); ++i) {
                ZetStream stream = this.streams.get(i);
                if (stream.current() == -1L || stream.current() > min) continue;
                min = stream.current();
                index = i;
            }
            if (index < 0) {
                return -1L;
            }
            this.streams.get(index).next();
            return min;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1L;
        }
    }

    public static class Union
    implements ZetStream {
        private final List<ZetStreamWithIndex> streams = new ArrayList<ZetStreamWithIndex>();
        private final int minFrequency;
        private final int maxFrequency;
        private final boolean consecutive;
        private Comparator<ZetStreamWithIndex> comparator = Comparator.comparing(a -> a.stream.current());
        private long current = -1L;
        private long next = -1L;

        public Union(List<ZetStream> streams) {
            this(streams, 1, Integer.MAX_VALUE, false);
        }

        public Union(ZetStream ... streams) {
            this(Arrays.asList(streams));
        }

        public Union(List<ZetStream> streams, int minFrequency, int maxFrequency, boolean consecutive) {
            for (int i = 0; i < streams.size(); ++i) {
                this.streams.add(new ZetStreamWithIndex(streams.get(i), i));
            }
            this.streams.forEach(s -> s.stream.next());
            this.streams.sort(this.comparator);
            while (!this.streams.isEmpty() && this.streams.get((int)0).stream.current() == -1L) {
                this.streams.remove(0);
            }
            this.minFrequency = minFrequency;
            this.maxFrequency = maxFrequency;
            this.consecutive = consecutive;
        }

        @Override
        public long current() {
            return this.current;
        }

        @Override
        public long next() {
            if (this.current == this.next) {
                this.hasNext();
            }
            this.current = this.next;
            return this.current;
        }

        @Override
        public boolean hasNext() {
            if (this.current != this.next) {
                return true;
            }
            while (true) {
                long l = this.next = !this.streams.isEmpty() ? this.streams.get((int)0).stream.current() : -1L;
                if (this.next == -1L) {
                    return false;
                }
                List<ZetStreamWithIndex> streams = this.itemsWith(this.next);
                if (this.current != this.next && this.isValid(streams)) {
                    this.updateStreams(streams);
                    return true;
                }
                this.updateStreams(streams);
            }
        }

        private void updateStreams(List<ZetStreamWithIndex> items) {
            for (int i = 0; i < items.size(); ++i) {
                ZetStreamWithIndex stream = this.streams.remove(0);
                if (!stream.stream.hasNext()) continue;
                stream.stream.next();
                int index = Collections.binarySearch(this.streams, stream, this.comparator);
                index = index < 0 ? (index + 1) * -1 : index;
                this.streams.add(index, stream);
            }
        }

        private boolean isValid(List<ZetStreamWithIndex> streams) {
            if (!this.consecutive) {
                return streams.size() >= this.minFrequency && streams.size() <= this.maxFrequency;
            }
            streams.sort(Comparator.comparing(i -> i.index));
            int count = 0;
            int lastIndex = -2;
            for (ZetStreamWithIndex stream : streams) {
                if (stream.index - lastIndex != 1) {
                    if (count >= this.minFrequency && count <= this.maxFrequency) {
                        return true;
                    }
                    count = 0;
                } else {
                    ++count;
                }
                lastIndex = stream.index;
            }
            return count >= this.minFrequency && count <= this.maxFrequency;
        }

        private List<ZetStreamWithIndex> itemsWith(long key) {
            ArrayList<ZetStreamWithIndex> streams = new ArrayList<ZetStreamWithIndex>();
            for (ZetStreamWithIndex stream : this.streams) {
                if (stream.stream.current() != key) break;
                streams.add(stream);
            }
            return streams;
        }
    }

    public static class Intersection
    implements ZetStream {
        private final List<ZetStream> streams;
        private long next;
        private long current;

        public Intersection(List<ZetStream> streams) {
            this.streams = streams;
            this.next = this.nextValue(this.advancing());
            this.current = 0L;
        }

        public Intersection(ZetStream ... streams) {
            this(Arrays.asList(streams));
        }

        @Override
        public long current() {
            return this.current;
        }

        @Override
        public long next() {
            this.current = this.next;
            this.next = this.nextValue(this.advancing());
            return this.current;
        }

        private long advancing() {
            long max = Long.MIN_VALUE;
            for (ZetStream stream : this.streams) {
                if (!stream.hasNext()) {
                    return Long.MAX_VALUE;
                }
                max = Math.max(max, stream.next());
            }
            return max;
        }

        private long nextValue(long max) {
            if (max == Long.MAX_VALUE) {
                return -1L;
            }
            for (int i = 0; i < this.streams.size(); ++i) {
                ZetStream stream = this.streams.get(i);
                while (stream.current() < max) {
                    if (stream.current() == -1L || !stream.hasNext()) {
                        return -1L;
                    }
                    stream.next();
                }
                if (stream.current() == max) continue;
                max = stream.current();
                i = -1;
            }
            return max;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1L;
        }
    }

    public static class SymmetricDifference
    implements ZetStream {
        private final List<ZetStream> streams;
        private long next;
        private long current;

        public SymmetricDifference(List<ZetStream> streams) {
            this.streams = streams;
            this.streams.forEach(ZetStream::next);
            this.next = this.nextValue();
            this.current = -1L;
        }

        public SymmetricDifference(ZetStream ... streams) {
            this(Arrays.asList(streams));
        }

        @Override
        public long current() {
            return this.current;
        }

        @Override
        public long next() {
            this.current = this.next;
            this.next = this.nextValue();
            return this.current;
        }

        private long nextValue() {
            long min;
            int index;
            boolean duplicated;
            do {
                index = -1;
                min = Long.MAX_VALUE;
                duplicated = false;
                for (int i = 0; i < this.streams.size(); ++i) {
                    ZetStream stream = this.streams.get(i);
                    if (stream.current() == -1L || stream.current() > min) continue;
                    if (stream.current() < min) {
                        min = stream.current();
                        index = i;
                        continue;
                    }
                    duplicated = true;
                    this.advance(index);
                    this.advance(i);
                    for (int j = i + 1; j < this.streams.size(); ++j) {
                        if (this.streams.get(j).current() != min) continue;
                        this.advance(j);
                    }
                    break;
                }
                if (index >= 0) continue;
                return -1L;
            } while (duplicated);
            this.advance(index);
            return min;
        }

        private void advance(int i) {
            if (this.streams.get(i).hasNext()) {
                this.streams.get(i).next();
            } else {
                this.streams.set(i, Empty.instance);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != -1L;
        }
    }

    public static class Difference
    implements ZetStream {
        private final List<ZetStream> streams;
        private final ZetStream stream;
        private long next;
        private long current = -1L;

        public Difference(List<ZetStream> streams) {
            this.stream = streams.size() > 0 ? streams.get(0) : null;
            this.streams = new ArrayList<ZetStream>(streams.subList(1, streams.size()));
            this.streams.forEach(ZetStream::next);
            this.next = this.stream != null ? this.nextValue() : -1L;
        }

        public Difference(ZetStream ... streams) {
            this(Arrays.asList(streams));
        }

        @Override
        public long current() {
            return this.current;
        }

        @Override
        public long next() {
            this.current = this.next;
            this.next = this.nextValue();
            return this.current;
        }

        private long nextValue() {
            while (this.stream.hasNext()) {
                long value = this.stream.next();
                boolean ignore = false;
                for (ZetStream zetStream : this.streams) {
                    while (zetStream.current() != -1L && zetStream.current() < value) {
                        zetStream.next();
                    }
                    if (zetStream.current() != value) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                return value;
            }
            return -1L;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1L;
        }
    }
}

