/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.mapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public interface MappStream
extends Iterator<Item> {
    @Override
    public boolean hasNext();

    @Override
    public Item next();

    public void close();

    public static class Merge {
        private Merge() {
        }

        public static MappStream of(final List<MappStream> cursors) {
            return new MappStream(){
                private List<MappStreamWithCurrent> streams;
                private Comparator<MappStreamWithCurrent> comparator;
                {
                    this.streams = cursors.stream().map(x$0 -> new MappStreamWithCurrent((MappStream)x$0)).collect(Collectors.toList());
                    this.comparator = Comparator.comparing(a -> a.current().key());
                    this.streams.forEach(MappStreamWithCurrent::next);
                    this.streams.sort(this.comparator);
                }

                @Override
                public Item next() {
                    long key = this.streams.get((int)0).current.key();
                    List<Item> items = this.itemsWith(key);
                    this.updateStreams(items);
                    return this.compositeItem(items);
                }

                private void updateStreams(List<Item> items) {
                    for (int i = 0; i < items.size(); ++i) {
                        MappStreamWithCurrent stream = this.streams.remove(0);
                        stream.next();
                        int index = Collections.binarySearch(this.streams, stream, this.comparator);
                        index = index < 0 ? (index + 1) * -1 : index;
                        this.streams.add(index, stream);
                    }
                }

                private List<Item> itemsWith(long key) {
                    ArrayList<Item> items = new ArrayList<Item>();
                    for (MappStreamWithCurrent stream : this.streams) {
                        if (stream.current.key() != key) break;
                        items.add(stream.current);
                    }
                    return items;
                }

                private Item compositeItem(final List<Item> items) {
                    return new Item(){

                        @Override
                        public long key() {
                            return ((Item)items.get(0)).key();
                        }

                        @Override
                        public String value() {
                            ArrayList<String> result = new ArrayList<String>();
                            for (Item item : items) {
                                result.add(item.value());
                            }
                            return String.join((CharSequence)"\n", result);
                        }
                    };
                }

                @Override
                public boolean hasNext() {
                    return !this.streams.isEmpty() && this.streams.get(0).current().key() != Long.MAX_VALUE;
                }

                @Override
                public void close() {
                    this.streams.forEach(MappStreamWithCurrent::close);
                }

                class MappStreamWithCurrent {
                    private final MappStream stream;
                    private Item current = null;

                    MappStreamWithCurrent(MappStream stream) {
                        this.stream = stream;
                    }

                    Item current() {
                        return this.current;
                    }

                    Item next() {
                        this.current = this.hasNext() ? this.stream.next() : this.nullItem();
                        return this.current;
                    }

                    private Item nullItem() {
                        return new Item(){

                            @Override
                            public long key() {
                                return Long.MAX_VALUE;
                            }

                            @Override
                            public String value() {
                                return null;
                            }
                        };
                    }

                    boolean hasNext() {
                        return this.stream.hasNext();
                    }

                    void close() {
                        this.stream.close();
                    }
                }
            };
        }
    }

    public static interface Item {
        public long key();

        public String value();
    }
}

