/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.StubConnector;
import io.intino.alexandria.zim.ZimStream;
import io.intino.cosmos.datahub.WizardTerminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Appliance;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.ApplicationJava;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure;
import io.intino.cosmos.datahub.datamarts.master.entities.Hardware;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.datamarts.master.entities.Observer;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.cosmos.datahub.datamarts.master.entities.Part;
import io.intino.cosmos.datahub.datamarts.master.entities.Person;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.cosmos.datahub.datamarts.master.entities.Process;
import io.intino.cosmos.datahub.datamarts.master.entities.Query;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;
import io.intino.cosmos.datahub.datamarts.master.entities.Software;
import io.intino.cosmos.datahub.datamarts.master.entities.Tag;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplianceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationJavaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AreaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AssetMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ComputerMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.CountermeasureMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.HardwareMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.IncidentRuleMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ModelMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ObserverMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.OrderTypeMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PartMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PersonMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PlaceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ProcessMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.QueryMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ServiceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.SoftwareMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.TagMounter;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import io.intino.ness.master.reflection.DatamartDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import io.intino.sumus.chronos.Group;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.Shot;
import io.intino.sumus.chronos.State;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MasterDatamartImpl
implements MasterDatamart {
    private static final String DATAHUB_MESSAGE_TOPIC = "service.ness.datamarts";
    private static final MasterDatamartDefinition definition = new MasterDatamartDefinition();
    private static final Set<String> TIMELINE_EVENTS = Set.of("Analysis", "ComputerAssertion", "Computer", "Switch", "ApplianceAssertion", "CellularGateway", "Wireless", "Camera", "QueryAssertion", "RdbmsStatement", "ApplicationAssertion", "Application", "IncidentFinished", "Incident");
    private static final Set<String> REEL_EVENTS = Set.of("Status");
    private final Connector connector;
    private final WizardTerminal.DatamartsRetryConfig retryConfig;
    private final List<Datamart.EntityListener> entityListeners = new ArrayList<Datamart.EntityListener>();
    private final Map<String, List<MasterMounter>> mounters = new HashMap<String, List<MasterMounter>>();
    private final MasterDatamart.Entities entities;
    private Instant ts;
    private boolean hasLocalAccessToTimelines;
    private final Map<String, TimelineNodeImpl> timelines = new ConcurrentHashMap<String, TimelineNodeImpl>();
    private boolean hasLocalAccessToIndicators;
    private final Map<String, IndicatorNodeImpl> indicators = new ConcurrentHashMap<String, IndicatorNodeImpl>();
    private boolean hasLocalAccessToReels;
    private final Map<String, ReelNodeImpl> reels = new ConcurrentHashMap<String, ReelNodeImpl>();
    private volatile Datamart.Translator translator = new Datamart.Translator.Identity();
    private volatile boolean initializing = false;

    public MasterDatamartImpl(Connector connector, WizardTerminal.DatamartsRetryConfig retryConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.retryConfig = Objects.requireNonNull(retryConfig);
        this.entities = new MasterDatamart.Entities((MasterDatamart)this);
        this.initMounters();
    }

    public synchronized MasterDatamartImpl init(String datamartSourceSelector) {
        try {
            this.initializing = true;
            this.downloadDatamartFromDatahub(datamartSourceSelector);
            Logger.info((String)("MasterDatamart (" + (String)(this.snapshotTimetag().isEmpty() ? "" : "snapshot " + this.snapshotTimetag() + ", ") + this.connector.clientId() + ") initialized successfully."));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("MasterDatamart failed to start because a " + e.getClass().getName() + " occurred: " + e.getMessage());
        }
        finally {
            this.initializing = false;
        }
        return this;
    }

    public boolean requiresDatahubNotifications() {
        return true;
    }

    public int size() {
        return this.entities.size();
    }

    public int sizeDisabled() {
        return this.entities.sizeDisabled();
    }

    public <T extends Entity> T get(String id) {
        return (T)this.entities.get(id);
    }

    public Stream<Entity> entities() {
        return this.entities.streamGeneric();
    }

    public void addEntityListener(Datamart.EntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("EntityListener cannot be null");
        }
        this.entityListeners.add(listener);
    }

    public DatamartDefinition getDefinition() {
        return definition;
    }

    public List<String> listSnapshots() {
        try {
            Message message = this.requestResponseFromDatahub("listSnapshots", this.listSnapshotsRequest());
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleListSnapshotsResponse(message);
        }
        catch (Exception e) {
            Logger.error((String)("Could not download list of available snapshots: " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Message listSnapshotsRequest() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=snapshots");
        return message;
    }

    private List<String> handleListSnapshotsResponse(Message message) throws Exception {
        return Arrays.stream(((TextMessage)message).getText().split(",")).collect(Collectors.toList());
    }

    public synchronized MasterDatamart snapshot(final String timetag) {
        if (timetag == null) {
            return this;
        }
        return new MasterDatamartImpl(this, this.connector, this.retryConfig){

            @Override
            protected String snapshotTimetag() {
                return timetag;
            }

            @Override
            public synchronized MasterDatamart snapshot(String timetag2) {
                throw new UnsupportedOperationException("Cannot request snapshots to snapshot instances of a datamart");
            }
        }.init(null);
    }

    public Instant ts() {
        return this.ts;
    }

    public Place place(String id) {
        return id == null ? null : (Place)this.entities.get(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    public Place placeDisabled(String id) {
        return id == null ? null : (Place)this.entities.getDisabled(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    public Stream<Place> places() {
        return this.entities.stream(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    public Stream<Place> placesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    public Area area(String id) {
        return id == null ? null : (Area)this.entities.get(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    public Area areaDisabled(String id) {
        return id == null ? null : (Area)this.entities.getDisabled(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    public Stream<Area> areas() {
        return this.entities.stream(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    public Stream<Area> areasDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    public Tag tag(String id) {
        return id == null ? null : (Tag)this.entities.get(MasterDatamartImpl.definition.tagEntityDefinition, id);
    }

    public Tag tagDisabled(String id) {
        return id == null ? null : (Tag)this.entities.getDisabled(MasterDatamartImpl.definition.tagEntityDefinition, id);
    }

    public Stream<Tag> tags() {
        return this.entities.stream(MasterDatamartImpl.definition.tagEntityDefinition);
    }

    public Stream<Tag> tagsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.tagEntityDefinition);
    }

    public IncidentRule incidentRule(String id) {
        return id == null ? null : (IncidentRule)this.entities.get(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    public IncidentRule incidentRuleDisabled(String id) {
        return id == null ? null : (IncidentRule)this.entities.getDisabled(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    public Stream<IncidentRule> incidentRules() {
        return this.entities.stream(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    public Stream<IncidentRule> incidentRulesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    public Countermeasure countermeasure(String id) {
        return id == null ? null : (Countermeasure)this.entities.get(MasterDatamartImpl.definition.countermeasureEntityDefinition, id);
    }

    public Countermeasure countermeasureDisabled(String id) {
        return id == null ? null : (Countermeasure)this.entities.getDisabled(MasterDatamartImpl.definition.countermeasureEntityDefinition, id);
    }

    public Stream<Countermeasure> countermeasures() {
        return this.entities.stream(MasterDatamartImpl.definition.countermeasureEntityDefinition);
    }

    public Stream<Countermeasure> countermeasuresDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.countermeasureEntityDefinition);
    }

    public Model model(String id) {
        return id == null ? null : (Model)this.entities.get(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    public Model modelDisabled(String id) {
        return id == null ? null : (Model)this.entities.getDisabled(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    public Stream<Model> models() {
        return this.entities.stream(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    public Stream<Model> modelsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    public OrderType orderType(String id) {
        return id == null ? null : (OrderType)this.entities.get(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    public OrderType orderTypeDisabled(String id) {
        return id == null ? null : (OrderType)this.entities.getDisabled(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    public Stream<OrderType> orderTypes() {
        return this.entities.stream(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    public Stream<OrderType> orderTypesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    public Observable observable(String id) {
        return id == null ? null : (Observable)this.entities.getDescendant(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    public Observable observableDisabled(String id) {
        return id == null ? null : (Observable)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    public Stream<Observable> observables() {
        return Stream.of(this.persons(), this.processes(), this.assets(), this.parts(), this.hardwares(), this.softwares(), this.queries()).flatMap(Function.identity());
    }

    public Stream<Observable> observablesDisabled() {
        return Stream.of(this.personsDisabled(), this.processesDisabled(), this.assetsDisabled(), this.partsDisabled(), this.hardwaresDisabled(), this.softwaresDisabled(), this.queriesDisabled()).flatMap(Function.identity());
    }

    public Person person(String id) {
        return id == null ? null : (Person)this.entities.get(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    public Person personDisabled(String id) {
        return id == null ? null : (Person)this.entities.getDisabled(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    public Stream<Person> persons() {
        return this.entities.stream(MasterDatamartImpl.definition.personEntityDefinition);
    }

    public Stream<Person> personsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.personEntityDefinition);
    }

    public Process process(String id) {
        return id == null ? null : (Process)this.entities.get(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    public Process processDisabled(String id) {
        return id == null ? null : (Process)this.entities.getDisabled(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    public Stream<Process> processes() {
        return this.entities.stream(MasterDatamartImpl.definition.processEntityDefinition);
    }

    public Stream<Process> processesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.processEntityDefinition);
    }

    public Asset asset(String id) {
        return id == null ? null : (Asset)this.entities.get(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    public Asset assetDisabled(String id) {
        return id == null ? null : (Asset)this.entities.getDisabled(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    public Stream<Asset> assets() {
        return this.entities.stream(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    public Stream<Asset> assetsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    public Part part(String id) {
        return id == null ? null : (Part)this.entities.get(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    public Part partDisabled(String id) {
        return id == null ? null : (Part)this.entities.getDisabled(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    public Stream<Part> parts() {
        return this.entities.stream(MasterDatamartImpl.definition.partEntityDefinition);
    }

    public Stream<Part> partsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.partEntityDefinition);
    }

    public Hardware hardware(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendant(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    public Hardware hardwareDisabled(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    public Stream<Hardware> hardwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliances(), this.computers()).flatMap(Function.identity());
    }

    public Stream<Hardware> hardwaresDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliancesDisabled(), this.computersDisabled()).flatMap(Function.identity());
    }

    public Appliance appliance(String id) {
        return id == null ? null : (Appliance)this.entities.get(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    public Appliance applianceDisabled(String id) {
        return id == null ? null : (Appliance)this.entities.getDisabled(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    public Stream<Appliance> appliances() {
        return this.entities.stream(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    public Stream<Appliance> appliancesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    public Computer computer(String id) {
        return id == null ? null : (Computer)this.entities.get(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    public Computer computerDisabled(String id) {
        return id == null ? null : (Computer)this.entities.getDisabled(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    public Stream<Computer> computers() {
        return this.entities.stream(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    public Stream<Computer> computersDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    public Software software(String id) {
        return id == null ? null : (Software)this.entities.getDescendant(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    public Software softwareDisabled(String id) {
        return id == null ? null : (Software)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    public Stream<Software> softwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.softwareEntityDefinition), this.observers(), this.services(), this.applications()).flatMap(Function.identity());
    }

    public Stream<Software> softwaresDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.softwareEntityDefinition), this.observersDisabled(), this.servicesDisabled(), this.applicationsDisabled()).flatMap(Function.identity());
    }

    public Observer observer(String id) {
        return id == null ? null : (Observer)this.entities.get(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    public Observer observerDisabled(String id) {
        return id == null ? null : (Observer)this.entities.getDisabled(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    public Stream<Observer> observers() {
        return this.entities.stream(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    public Stream<Observer> observersDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    public Service service(String id) {
        return id == null ? null : (Service)this.entities.get(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    public Service serviceDisabled(String id) {
        return id == null ? null : (Service)this.entities.getDisabled(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    public Stream<Service> services() {
        return this.entities.stream(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    public Stream<Service> servicesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    public Query query(String id) {
        return id == null ? null : (Query)this.entities.get(MasterDatamartImpl.definition.queryEntityDefinition, id);
    }

    public Query queryDisabled(String id) {
        return id == null ? null : (Query)this.entities.getDisabled(MasterDatamartImpl.definition.queryEntityDefinition, id);
    }

    public Stream<Query> queries() {
        return this.entities.stream(MasterDatamartImpl.definition.queryEntityDefinition);
    }

    public Stream<Query> queriesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.queryEntityDefinition);
    }

    public Application application(String id) {
        return id == null ? null : (Application)this.entities.getDescendant(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    public Application applicationDisabled(String id) {
        return id == null ? null : (Application)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    public Stream<Application> applications() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.applicationEntityDefinition), this.applicationJavas()).flatMap(Function.identity());
    }

    public Stream<Application> applicationsDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.applicationEntityDefinition), this.applicationJavasDisabled()).flatMap(Function.identity());
    }

    public ApplicationJava applicationJava(String id) {
        return id == null ? null : (ApplicationJava)this.entities.get(MasterDatamartImpl.definition.applicationJavaEntityDefinition, id);
    }

    public ApplicationJava applicationJavaDisabled(String id) {
        return id == null ? null : (ApplicationJava)this.entities.getDisabled(MasterDatamartImpl.definition.applicationJavaEntityDefinition, id);
    }

    public Stream<ApplicationJava> applicationJavas() {
        return this.entities.stream(MasterDatamartImpl.definition.applicationJavaEntityDefinition);
    }

    public Stream<ApplicationJava> applicationJavasDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.applicationJavaEntityDefinition);
    }

    public Stream<MasterDatamart.TimelineNode> timelines(String id) {
        String key = id.replace(":", "-");
        Stream<MasterDatamart.TimelineNode> stream = this.timelines.values().stream().filter(t -> t.id.equals(key)).toList().stream();
        return stream;
    }

    public MasterDatamart.TimelineNode analysisTimeline(String id) {
        String key = this.normalizedId(id, "Analysis");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Analysis"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode computerTimeline(String id) {
        String key = this.normalizedId(id, "Computer");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Computer"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode switchTimeline(String id) {
        String key = this.normalizedId(id, "Switch");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Switch"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode cellularGatewayTimeline(String id) {
        String key = this.normalizedId(id, "CellularGateway");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "CellularGateway"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode wirelessTimeline(String id) {
        String key = this.normalizedId(id, "Wireless");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Wireless"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode cameraTimeline(String id) {
        String key = this.normalizedId(id, "Camera");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Camera"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode rdbmsStatementTimeline(String id) {
        String key = this.normalizedId(id, "RdbmsStatement");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "RdbmsStatement"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode applicationTimeline(String id) {
        String key = this.normalizedId(id, "Application");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Application"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public MasterDatamart.TimelineNode incidentsTimeline(String id) {
        String key = this.normalizedId(id, "incidents");
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "incidents"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    public Stream<MasterDatamart.ReelNode> reels(String id) {
        String key = id.replace(":", "-");
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.id.equals(key)).toList().stream();
        return stream;
    }

    public MasterDatamart.ReelNode statusReel(String id) {
        String key = this.normalizedId(id, "Status");
        if (this.reels.containsKey(key)) {
            return this.reels.get(key);
        }
        if (!this.hasLocalAccessToReels) {
            return this.reels.computeIfAbsent(key, theId -> new ReelNodeImpl(id, "Status"));
        }
        return MasterDatamart.ReelNode.empty();
    }

    public Stream<MasterDatamart.ReelNode> statusReels() {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.type.equals("Status")).toList().stream();
        return stream;
    }

    public MasterDatamart.IndicatorNode pendingIncidentsIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("incidents.pendingIncidents") ? (MasterDatamart.IndicatorNode)this.indicators.get("incidents.pendingIncidents") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("incidents.pendingIncidents", theId -> new IndicatorNodeImpl("incidents.pendingIncidents", null));
    }

    public MasterDatamart.IndicatorNode incidentFinishedTimeIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("incidents.incidentFinishedTime") ? (MasterDatamart.IndicatorNode)this.indicators.get("incidents.incidentFinishedTime") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("incidents.incidentFinishedTime", theId -> new IndicatorNodeImpl("incidents.incidentFinishedTime", null));
    }

    public MasterDatamart.IndicatorNode availabilityIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.availability") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.availability") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.availability", theId -> new IndicatorNodeImpl("Analysis.availability", null));
    }

    public MasterDatamart.IndicatorNode healthIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.health") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.health") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.health", theId -> new IndicatorNodeImpl("Analysis.health", null));
    }

    public MasterDatamart.IndicatorNode riskIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.risk") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.risk") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.risk", theId -> new IndicatorNodeImpl("Analysis.risk", null));
    }

    public MasterDatamart.IndicatorNode usageRAMIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageRAM") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageRAM") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageRAM", theId -> new IndicatorNodeImpl("Computer.usageRAM", null));
    }

    public MasterDatamart.IndicatorNode usageHDDIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageHDD") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageHDD") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageHDD", theId -> new IndicatorNodeImpl("Computer.usageHDD", null));
    }

    public MasterDatamart.IndicatorNode usageCPUIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageCPU") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageCPU") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageCPU", theId -> new IndicatorNodeImpl("Computer.usageCPU", null));
    }

    public MasterDatamart.IndicatorNode usageSystemIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageSystem") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageSystem") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageSystem", theId -> new IndicatorNodeImpl("Computer.usageSystem", null));
    }

    public MasterDatamart.IndicatorNode usageThreadsIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageThreads") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageThreads") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageThreads", theId -> new IndicatorNodeImpl("Computer.usageThreads", null));
    }

    public MasterDatamart.IndicatorNode usageFilesIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageFiles") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageFiles") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageFiles", theId -> new IndicatorNodeImpl("Computer.usageFiles", null));
    }

    public MasterDatamart.IndicatorNode temperatureKernelIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.temperatureKernel") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.temperatureKernel") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.temperatureKernel", theId -> new IndicatorNodeImpl("Computer.temperatureKernel", null));
    }

    public MasterDatamart.IndicatorNode temperatureExternalIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.temperatureExternal") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.temperatureExternal") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.temperatureExternal", theId -> new IndicatorNodeImpl("Computer.temperatureExternal", null));
    }

    public MasterDatamart.IndicatorNode dataReceivedIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.dataReceived") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.dataReceived") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.dataReceived", theId -> new IndicatorNodeImpl("Computer.dataReceived", null));
    }

    public MasterDatamart.IndicatorNode dataSentIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.dataSent") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.dataSent") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.dataSent", theId -> new IndicatorNodeImpl("Computer.dataSent", null));
    }

    public MasterDatamart.IndicatorNode applicationsSystemIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsSystem") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsSystem") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsSystem", theId -> new IndicatorNodeImpl("Computer.applicationsSystem", null));
    }

    public MasterDatamart.IndicatorNode applicationsKnownIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsKnown") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsKnown") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsKnown", theId -> new IndicatorNodeImpl("Computer.applicationsKnown", null));
    }

    public MasterDatamart.IndicatorNode applicationsUnknownIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsUnknown") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsUnknown") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsUnknown", theId -> new IndicatorNodeImpl("Computer.applicationsUnknown", null));
    }

    public Datamart.Translator translator() {
        return this.translator;
    }

    public void translator(Datamart.Translator translator) {
        this.translator = translator;
    }

    private void downloadDatamartFromDatahub(String datamartSourceSelector) throws MasterDatamart.DatahubRequestException {
        if (this.connector instanceof StubConnector) {
            return;
        }
        Logger.debug((String)"Downloading datamart from datahub...");
        long start = System.currentTimeMillis();
        Logger.debug((String)"Downloading entities...");
        int[] eventCount = new int[1];
        this.loadEntitiesFromEvents(this.downloadEntities(eventCount, datamartSourceSelector), eventCount);
        this.loadTimelinesFromDatahub();
        this.loadIndicatorsFromDatahub();
        this.loadReelsFromDatahub();
        long time = System.currentTimeMillis() - start;
        Logger.debug((String)("Datamart downloaded from datahub after " + time + " ms"));
    }

    private void loadTimelinesFromDatahub() {
        Logger.debug((String)"Downloading timelines...");
        Boolean hasLocalAccessToTimelines = null;
        for (String filename : this.listTimelineFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".timeline", "");
                String type = file.getParentFile().getName();
                TimelineNodeImpl node = new TimelineNodeImpl(id, type, file.exists() ? file : null);
                this.timelines.put(id + ":" + type, node);
                if (hasLocalAccessToTimelines == null) {
                    hasLocalAccessToTimelines = file.exists();
                    continue;
                }
                hasLocalAccessToTimelines = hasLocalAccessToTimelines & file.exists();
            }
            catch (Exception e) {
                Logger.debug((String)("Could not load timeline " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        this.hasLocalAccessToTimelines = hasLocalAccessToTimelines != null && hasLocalAccessToTimelines != false;
        Logger.debug((String)("Loaded " + this.timelines.size() + " timelines (hasLocalAccessToTimelines=" + this.hasLocalAccessToTimelines + ")"));
    }

    private String[] listTimelineFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-timelines;");
            Message message = this.requestResponseFromDatahub("list-timelines", (Message)request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new String[0];
        }
    }

    private void loadIndicatorsFromDatahub() {
        Logger.debug((String)"Downloading indicators...");
        Boolean hasLocalAccessToIndicators = null;
        for (String filename : this.listIndicatorFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".indicator", "");
                IndicatorNodeImpl node = new IndicatorNodeImpl(id, file.exists() ? file : null);
                this.indicators.put(id, node);
                if (hasLocalAccessToIndicators == null) {
                    hasLocalAccessToIndicators = file.exists();
                    continue;
                }
                hasLocalAccessToIndicators = hasLocalAccessToIndicators & file.exists();
            }
            catch (Exception e) {
                Logger.debug((String)("Could not load indicator " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        this.hasLocalAccessToIndicators = hasLocalAccessToIndicators != null && hasLocalAccessToIndicators != false;
        Logger.debug((String)("Loaded " + this.indicators.size() + " indicators (hasLocalAccessToTimelines=" + this.hasLocalAccessToTimelines + ")"));
    }

    private String[] listIndicatorFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-indicators;");
            Message message = this.requestResponseFromDatahub("list-indicators", (Message)request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new String[0];
        }
    }

    private void loadReelsFromDatahub() {
        Logger.debug((String)"Downloading reels...");
        Boolean hasLocalAccessToReels = null;
        for (String filename : this.listReelFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".reel", "");
                String type = file.getParentFile().getName();
                ReelNodeImpl node = new ReelNodeImpl(id, type, file.exists() ? file : null);
                this.reels.put(id + ":" + type, node);
                if (hasLocalAccessToReels == null) {
                    hasLocalAccessToReels = file.exists();
                    continue;
                }
                hasLocalAccessToReels = hasLocalAccessToReels & file.exists();
            }
            catch (Exception e) {
                Logger.debug((String)("Could not load reel " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        this.hasLocalAccessToReels = hasLocalAccessToReels != null && hasLocalAccessToReels != false;
        Logger.debug((String)("Loaded " + this.reels.size() + " reels"));
    }

    private String[] listReelFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-reels;");
            Message message = this.requestResponseFromDatahub("list-reels", (Message)request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new String[0];
        }
    }

    private Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) throws MasterDatamart.DatahubRequestException {
        try {
            Message message = this.requestResponseFromDatahub("downloadEvents", this.downloadEntitiesRequest(datamartSourceSelector));
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleDownloadResponse(message, eventCount);
        }
        catch (NullPointerException e) {
            throw new MasterDatamart.DatahubRequestException("Could not download datamart: no response from datahub.");
        }
        catch (MasterDatamart.DatahubRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MasterDatamart.DatahubRequestException("Could not download datamart: " + e.getMessage());
        }
    }

    private Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=entities" + (String)(this.snapshotTimetag().isEmpty() ? "" : ";timetag=" + this.snapshotTimetag()) + (String)(datamartSourceSelector == null ? "" : ";sourceSelector=" + datamartSourceSelector));
        return message;
    }

    protected String snapshotTimetag() {
        return "";
    }

    private Stream<Event> handleDownloadResponse(Message message, int[] eventCount) throws Exception {
        BytesMessage m = (BytesMessage)message;
        eventCount[0] = m.getIntProperty("size");
        int size = m.getIntProperty("size");
        byte[] bytes = new byte[size];
        m.readBytes(bytes, size);
        return ZimStream.of((InputStream)new ByteArrayInputStream(bytes)).map(MessageEvent::new);
    }

    private void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {
        events.forEach(this::mount);
    }

    public synchronized void mount(Event event) {
        try {
            if (event == null) {
                return;
            }
            this.ts = event.ts();
            this.mountEntities(event);
        }
        catch (Throwable e) {
            Logger.error((String)("Error while mounting event ss=" + event.ss() + ", ts=" + String.valueOf(event.ts()) + " -> " + e.getMessage()), (Throwable)e);
        }
    }

    public synchronized void handleDatahubNotification(String notification) {
        try {
            if (notification == null || notification.isBlank()) {
                return;
            }
            String[] typeAndSs = notification.split("\u0000");
            this.handleTimelineNotification(typeAndSs[0], typeAndSs[1]);
            this.handleReelNotification(typeAndSs[0], typeAndSs[1]);
        }
        catch (Throwable e) {
            Logger.error((String)("Error while processing datahub notification " + notification + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void handleReelNotification(String type, String id) {
        if (!REEL_EVENTS.contains(type)) {
            return;
        }
        String key = this.normalizedId(id, type);
        ReelNodeImpl reel = this.reels.computeIfAbsent(key, k -> new ReelNodeImpl(id, type, null));
        reel.notifyChange();
    }

    private void handleTimelineNotification(String type, String id) {
        if (!TIMELINE_EVENTS.contains(type)) {
            return;
        }
        String key = this.normalizedId(id, type);
        TimelineNodeImpl timeline = this.timelines.computeIfAbsent(key, k -> new TimelineNodeImpl(id, type, null));
        timeline.notifyChange();
    }

    private String normalizedId(String id, String type) {
        return id.replace(":", "-") + ":" + type;
    }

    private void mountEntities(Event event) {
        try {
            List<MasterMounter> mounters = this.mounters.get(event.type());
            if (mounters == null) {
                return;
            }
            mounters.forEach(mounter -> mounter.useListeners(!this.initializing).mount(event));
        }
        catch (Exception e) {
            Logger.error((String)("Failed to mount event of type " + event.type() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void initMounters() {
        this.mounters.computeIfAbsent("PlaceAssertion", type -> new ArrayList(1)).add(new PlaceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AreaAssertion", type -> new ArrayList(1)).add(new AreaMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("TagAssertion", type -> new ArrayList(1)).add(new TagMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("IncidentRuleAssertion", type -> new ArrayList(1)).add(new IncidentRuleMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("CountermeasureAssertion", type -> new ArrayList(1)).add(new CountermeasureMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ModelAssertion", type -> new ArrayList(1)).add(new ModelMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("OrderTypeAssertion", type -> new ArrayList(1)).add(new OrderTypeMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PersonAssertion", type -> new ArrayList(1)).add(new PersonMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ProcessAssertion", type -> new ArrayList(1)).add(new ProcessMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AssetAssertion", type -> new ArrayList(1)).add(new AssetMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PartAssertion", type -> new ArrayList(1)).add(new PartMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("HardwareAssertion", type -> new ArrayList(1)).add(new HardwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplianceAssertion", type -> new ArrayList(1)).add(new ApplianceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ComputerAssertion", type -> new ArrayList(1)).add(new ComputerMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("SoftwareAssertion", type -> new ArrayList(1)).add(new SoftwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ObserverAssertion", type -> new ArrayList(1)).add(new ObserverMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ServiceAssertion", type -> new ArrayList(1)).add(new ServiceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("QueryAssertion", type -> new ArrayList(1)).add(new QueryMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationAssertion", type -> new ArrayList(1)).add(new ApplicationMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationJavaAssertion", type -> new ArrayList(1)).add(new ApplicationJavaMounter(this.entities, this.entityListeners));
    }

    private static int availableThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Message requestResponseFromDatahub(String requestName, Message request) throws MasterDatamart.DatahubRequestException {
        long timeout = this.retryConfig.initialTimeoutAmount;
        for (int i = 0; i < this.retryConfig.maxAttempts; ++i) {
            Message message = this.connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, this.retryConfig.timeoutUnit);
            if (message != null) {
                return message;
            }
            if (i < this.retryConfig.maxAttempts - 1) {
                Logger.warn((String)("(" + (i + 1) + ") Datahub did not respond after " + timeout + " " + String.valueOf((Object)this.retryConfig.timeoutUnit) + " to the request '" + requestName + "'. Trying again..."));
            }
            timeout = (long)((float)timeout * this.retryConfig.timeoutMultiplier);
        }
        throw new MasterDatamart.DatahubRequestException("Datahub did not respond to the request '" + requestName + "' after " + this.retryConfig.maxAttempts);
    }

    private static Set<String> sourcesOfTimeline(String type) {
        return switch (type) {
            case "Analysis" -> Set.of("Analysis");
            case "Computer" -> Set.of("Computer", "ComputerAssertion");
            case "Switch" -> Set.of("Switch", "ApplianceAssertion");
            case "CellularGateway" -> Set.of("CellularGateway", "ApplianceAssertion");
            case "Wireless" -> Set.of("Wireless", "ApplianceAssertion");
            case "Camera" -> Set.of("Camera", "ApplianceAssertion");
            case "RdbmsStatement" -> Set.of("RdbmsStatement", "QueryAssertion");
            case "Application" -> Set.of("Application", "ApplicationAssertion");
            case "incidents" -> Set.of("IncidentFinished", "Incident");
            default -> Collections.emptySet();
        };
    }

    private static Set<String> sourcesOfReel(String type) {
        return switch (type) {
            case "Status" -> Set.of("Datalake#dl$status");
            default -> Collections.emptySet();
        };
    }

    static {
        try {
            Object ref = MasterDatamart.class.getDeclaredField("definition").get(null);
            Field field = ref.getClass().getDeclaredField("definition");
            field.setAccessible(true);
            field.set(ref, definition);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Could not set MasterDatamart.definition field");
        }
    }

    public static final class MasterDatamartDefinition
    implements DatamartDefinition {
        public final EntityDefinition placeEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Place";
            }

            public String name() {
                return "Place";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Place.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "coordinates";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "timeOffset";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "region";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "city";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "area";
                    }

                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "address";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "postalCode";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition areaEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Area";
            }

            public String name() {
                return "Area";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Area.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition tagEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Tag";
            }

            public String name() {
                return "Tag";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Tag.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition incidentRuleEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "IncidentRule";
            }

            public String name() {
                return "IncidentRule";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return IncidentRule.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "target";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "model";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "condition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "precondition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "level";
                    }

                    public Class<?> type() {
                        return IncidentRule.Level.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "tracking";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "dismissCondition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "triggers";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition countermeasureEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Countermeasure";
            }

            public String name() {
                return "Countermeasure";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Countermeasure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "condition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "priority";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "actuationList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().countermeasure$ActuationStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Countermeasure.Actuation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition modelEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model";
            }

            public String name() {
                return "Model";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "target";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "profile";
                    }

                    public Class<?> type() {
                        return Model.Profile.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition orderTypeEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "OrderType";
            }

            public String name() {
                return "OrderType";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return OrderType.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observableEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable";
            }

            public String name() {
                return "Observable";
            }

            public boolean isAbstract() {
                return true;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of(personEntityDefinition, processEntityDefinition, assetEntityDefinition, partEntityDefinition, hardwareEntityDefinition, applianceEntityDefinition, computerEntityDefinition, softwareEntityDefinition, observerEntityDefinition, serviceEntityDefinition, queryEntityDefinition, applicationEntityDefinition, applicationJavaEntityDefinition);
            }

            public Class<?> javaClass() {
                return Observable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "place";
                    }

                    public Class<?> type() {
                        return Place.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "team";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "model";
                    }

                    public Class<?> type() {
                        return Model.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "container";
                    }

                    public Class<?> type() {
                        return Observable.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "observer";
                    }

                    public Class<?> type() {
                        return Observer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "responsible";
                    }

                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "tags";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "operationList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$OperationStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition personEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Person";
            }

            public String name() {
                return "Person";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Person.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "area";
                    }

                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "role";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "supervisor";
                    }

                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "email";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "phone";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition processEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Process";
            }

            public String name() {
                return "Process";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Process.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition assetEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Asset";
            }

            public String name() {
                return "Asset";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Asset.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition partEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Part";
            }

            public String name() {
                return "Part";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Part.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition hardwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware";
            }

            public String name() {
                return "Hardware";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(applianceEntityDefinition, computerEntityDefinition);
            }

            public Class<?> javaClass() {
                return Hardware.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "sn";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "ip";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "publicIp";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applianceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware.Appliance";
            }

            public String name() {
                return "Appliance";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Appliance.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition computerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware.Computer";
            }

            public String name() {
                return "Computer";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Computer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "architecture";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "os";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "cores";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "diskSize";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "memorySize";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "processes";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "maxOpenFiles";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "jvm";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "isp";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition softwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software";
            }

            public String name() {
                return "Software";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, applicationJavaEntityDefinition);
            }

            public Class<?> javaClass() {
                return Software.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Observer";
            }

            public String name() {
                return "Observer";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "version";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "installedActivities";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "enabledActivities";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition serviceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Service";
            }

            public String name() {
                return "Service";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Service.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<1> list = new ArrayList<1>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "url";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition queryEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Query";
            }

            public String name() {
                return "Query";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Query.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "query";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "hash";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Application";
            }

            public String name() {
                return "Application";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(applicationJavaEntityDefinition);
            }

            public Class<?> javaClass() {
                return Application.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "user";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "systemService";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "startingTime";
                    }

                    public Class<?> type() {
                        return LocalDateTime.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "pid";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "commandLine";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "state";
                    }

                    public Class<?> type() {
                        return Application.State.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationJavaEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Application.ApplicationJava";
            }

            public String name() {
                return "ApplicationJava";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(applicationEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(applicationEntityDefinition, softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return ApplicationJava.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "classpathPrefix";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "mainArtifact";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "debugPort";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "jmxPort";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "minMemory";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "maxMemory";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "classpath";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "inputArguments";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "jvmParameter";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "jvmVersion";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition countermeasure$ActuationStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Countermeasure$Actuation";
            }

            public String name() {
                return "Actuation";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Countermeasure.Actuation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "target";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "tries";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "tryInterval";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "extraCondition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "notification";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "dismissNotification";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "channels";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$ProfileStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model$Profile";
            }

            public String name() {
                return "Profile";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.Profile.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<MasterDatamartDefinition.1> list = new ArrayList<MasterDatamartDefinition.1>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "variableList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().model$Profile$VariableStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Model.Profile.Variable.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$Profile$VariableStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model$Profile$Variable";
            }

            public String name() {
                return "Variable";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.Profile.Variable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "className";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "operator";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "unit";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "symbol";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "values";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "priority";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "min";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "max";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "format";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$OperationStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation";
            }

            public String name() {
                return "Operation";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "activity";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "procedureList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$ProcedureStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$ProcedureStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation$Procedure";
            }

            public String name() {
                return "Procedure";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.Procedure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "returnType";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "parameterList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$Procedure$ParameterStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.Parameter.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$Procedure$ParameterStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation$Procedure$Parameter";
            }

            public String name() {
                return "Parameter";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.Procedure.Parameter.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };

        public String name() {
            return "master";
        }

        public Datamart.Scale scale() {
            return Datamart.Scale.Day;
        }

        public DatamartDefinition.Query<EntityDefinition> entities() {
            return new DatamartDefinition.Query(List.of(this.placeEntityDefinition, this.areaEntityDefinition, this.tagEntityDefinition, this.incidentRuleEntityDefinition, this.countermeasureEntityDefinition, this.modelEntityDefinition, this.orderTypeEntityDefinition, this.observableEntityDefinition, this.personEntityDefinition, this.processEntityDefinition, this.assetEntityDefinition, this.partEntityDefinition, this.hardwareEntityDefinition, this.applianceEntityDefinition, this.computerEntityDefinition, this.softwareEntityDefinition, this.observerEntityDefinition, this.serviceEntityDefinition, this.queryEntityDefinition, this.applicationEntityDefinition, this.applicationJavaEntityDefinition));
        }

        public DatamartDefinition.Query<StructDefinition> structs() {
            return new DatamartDefinition.Query(List.of(this.countermeasure$ActuationStructDefinition, this.model$ProfileStructDefinition, this.model$Profile$VariableStructDefinition, this.observable$OperationStructDefinition, this.observable$Operation$ProcedureStructDefinition, this.observable$Operation$Procedure$ParameterStructDefinition));
        }

        public Optional<EntityDefinition> entity(String name) {
            switch (name) {
                case "Place": {
                    return Optional.of(this.placeEntityDefinition);
                }
                case "Area": {
                    return Optional.of(this.areaEntityDefinition);
                }
                case "Tag": {
                    return Optional.of(this.tagEntityDefinition);
                }
                case "IncidentRule": {
                    return Optional.of(this.incidentRuleEntityDefinition);
                }
                case "Countermeasure": {
                    return Optional.of(this.countermeasureEntityDefinition);
                }
                case "Model": {
                    return Optional.of(this.modelEntityDefinition);
                }
                case "OrderType": {
                    return Optional.of(this.orderTypeEntityDefinition);
                }
                case "Observable": {
                    return Optional.of(this.observableEntityDefinition);
                }
                case "Person": {
                    return Optional.of(this.personEntityDefinition);
                }
                case "Process": {
                    return Optional.of(this.processEntityDefinition);
                }
                case "Asset": {
                    return Optional.of(this.assetEntityDefinition);
                }
                case "Part": {
                    return Optional.of(this.partEntityDefinition);
                }
                case "Hardware": {
                    return Optional.of(this.hardwareEntityDefinition);
                }
                case "Appliance": {
                    return Optional.of(this.applianceEntityDefinition);
                }
                case "Computer": {
                    return Optional.of(this.computerEntityDefinition);
                }
                case "Software": {
                    return Optional.of(this.softwareEntityDefinition);
                }
                case "Observer": {
                    return Optional.of(this.observerEntityDefinition);
                }
                case "Service": {
                    return Optional.of(this.serviceEntityDefinition);
                }
                case "Query": {
                    return Optional.of(this.queryEntityDefinition);
                }
                case "Application": {
                    return Optional.of(this.applicationEntityDefinition);
                }
                case "ApplicationJava": {
                    return Optional.of(this.applicationJavaEntityDefinition);
                }
            }
            return Optional.empty();
        }

        public Optional<StructDefinition> struct(String name) {
            switch (name) {
                case "Countermeasure$Actuation": {
                    return Optional.of(this.countermeasure$ActuationStructDefinition);
                }
                case "Model$Profile": {
                    return Optional.of(this.model$ProfileStructDefinition);
                }
                case "Model$Profile$Variable": {
                    return Optional.of(this.model$Profile$VariableStructDefinition);
                }
                case "Observable$Operation": {
                    return Optional.of(this.observable$OperationStructDefinition);
                }
                case "Observable$Operation$Procedure": {
                    return Optional.of(this.observable$Operation$ProcedureStructDefinition);
                }
                case "Observable$Operation$Procedure$Parameter": {
                    return Optional.of(this.observable$Operation$Procedure$ParameterStructDefinition);
                }
            }
            return Optional.empty();
        }

        private MasterDatamartDefinition datamart() {
            return this;
        }
    }

    private class TimelineNodeImpl
    implements MasterDatamart.TimelineNode {
        private final String id;
        private final String type;
        private volatile File file;
        private volatile TimelineStore timelineFile;
        private volatile MasterDatamart.TimelineNode.ChangeListener listener;
        private volatile boolean disposed;

        private TimelineNodeImpl(String id, String type) {
            this(id, type, null);
        }

        private TimelineNodeImpl(String id, String type, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.file = file;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public boolean exists() {
            try {
                return this.timelineFile() != null;
            }
            catch (MasterDatamart.TimelineNotAvailableException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.timelines.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        public TimelineStore.TimeModel timeModel() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().timeModel();
        }

        public TimelineStore.SensorModel sensorModel() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().sensorModel();
        }

        public Instant first() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().first();
        }

        public Instant last() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().last();
        }

        public Timeline get() throws MasterDatamart.TimelineNotAvailableException {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.TimelineNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    return this.timelineFile().timeline();
                }
                catch (Exception e) {
                    throw new MasterDatamart.TimelineNotAvailableException((Throwable)e);
                }
            }
        }

        private TimelineStore timelineFile() throws MasterDatamart.TimelineNotAvailableException {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.TimelineNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToTimelines && this.file != null && this.file.exists()) {
                        return this.loadFile();
                    }
                    if (this.timelineFile != null) {
                        return this.timelineFile;
                    }
                    this.timelineFile = this.downloadFromDatahub();
                    return this.timelineFile;
                }
                catch (Exception e) {
                    throw new MasterDatamart.TimelineNotAvailableException((Throwable)e);
                }
            }
        }

        public void setChangeListener(MasterDatamart.TimelineNode.ChangeListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyChange() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    this.clearCache();
                    if (this.listener != null) {
                        new Thread(() -> this.listener.notifyChange((MasterDatamart.TimelineNode)this), "Master-TimelineNodeImpl-" + System.currentTimeMillis()).start();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void clearCache() {
            this.timelineFile = null;
            if (!MasterDatamartImpl.this.hasLocalAccessToTimelines) {
                this.file = null;
            }
        }

        private TimelineStore loadFile() throws Exception {
            return TimelineStore.of((File)this.file);
        }

        private TimelineStore downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request(MasterDatamartImpl.this.hasLocalAccessToTimelines ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.TimelineNotAvailableException("Could not get timeline " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToTimelines = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToTimelines = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.TimelineNotAvailableException("Could not get timeline " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private TimelineStore readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".timeline");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            MasterDatamartImpl.this.hasLocalAccessToTimelines = false;
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-timeline;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }

    private class IndicatorNodeImpl
    implements MasterDatamart.IndicatorNode {
        private final String id;
        private volatile File file;

        private IndicatorNodeImpl(String id, File file) {
            this.id = Objects.requireNonNull(id);
            this.file = file;
        }

        public boolean exists() {
            try {
                return this.get() != null;
            }
            catch (MasterDatamart.IndicatorNotAvailableException e) {
                return false;
            }
        }

        public MasterDatamart.Indicator get() throws MasterDatamart.IndicatorNotAvailableException {
            IndicatorNodeImpl indicatorNodeImpl = this;
            synchronized (indicatorNodeImpl) {
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToIndicators) {
                        return MasterDatamart.Indicator.load((InputStream)new FileInputStream(this.file));
                    }
                    return this.downloadFromDatahub();
                }
                catch (Exception e) {
                    throw new MasterDatamart.IndicatorNotAvailableException((Throwable)e);
                }
            }
        }

        private MasterDatamart.Indicator downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-indicator=" + this.id, this.request(MasterDatamartImpl.this.hasLocalAccessToIndicators ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get indicator " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToIndicators = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToIndicators = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-indicator=" + this.id, this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get indicator " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private MasterDatamart.Indicator readFromBytes(BytesMessage m) throws Exception {
            int messageSize = m.getIntProperty("size");
            byte[] bytes = new byte[messageSize];
            m.readBytes(bytes, messageSize);
            return MasterDatamart.Indicator.load((InputStream)new ByteArrayInputStream(bytes));
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText("datamart=" + MasterDatamartImpl.this.name() + ";operation=get-indicator;id=" + this.id + ";mode=" + mode);
            return message;
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private MasterDatamart.Indicator loadFile() throws Exception {
            return MasterDatamart.Indicator.load((InputStream)new FileInputStream(this.file));
        }
    }

    private class ReelNodeImpl
    implements MasterDatamart.ReelNode {
        private final String id;
        private final String type;
        private volatile File file;
        private volatile ReelFile reelFile;
        private volatile MasterDatamart.ReelNode.ChangeListener listener;
        private volatile boolean disposed;

        private ReelNodeImpl(String id, String type) {
            this(id, type, null);
        }

        private ReelNodeImpl(String id, String type, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.file = file;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.reels.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        public Instant start() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                return null;
            }
            return reelFile.start();
        }

        public State stateOf(String signal) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastStateOf(signal);
        }

        public Set<String> signals() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.signals();
        }

        public List<State> stateOf(Stream<String> signals) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return signals.map(arg_0 -> ((ReelFile)reelFile).lastStateOf(arg_0)).toList();
        }

        public Shot lastShotOf(String signal) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShotOf(signal);
        }

        public List<Shot> lastShots() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots();
        }

        public List<Shot> lastShots(String group) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots(group);
        }

        public List<Shot> lastShots(Group group) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots(group);
        }

        public Reel get(Period period) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return this.reelFile().reel().by(period);
        }

        public Reel get(Instant from, Instant to, Period period) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.reel(from, to).by(period);
        }

        public boolean exists() {
            try {
                return this.reelFile() != null;
            }
            catch (MasterDatamart.ReelNotAvailableException e) {
                return false;
            }
        }

        private ReelFile reelFile() throws MasterDatamart.ReelNotAvailableException {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.ReelNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToReels && this.file != null && this.file.exists()) {
                        return this.loadFile();
                    }
                    if (this.reelFile != null) {
                        return this.reelFile;
                    }
                    this.reelFile = this.downloadFromDatahub();
                    return this.reelFile;
                }
                catch (Exception e) {
                    throw new MasterDatamart.ReelNotAvailableException((Throwable)e);
                }
            }
        }

        public void setChangeListener(MasterDatamart.ReelNode.ChangeListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyChange() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    this.clearCache();
                    if (this.listener != null) {
                        new Thread(() -> this.listener.notifyChange((MasterDatamart.ReelNode)this), "Master-ReelNodeImpl-" + System.currentTimeMillis()).start();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void clearCache() {
            this.reelFile = null;
            if (!MasterDatamartImpl.this.hasLocalAccessToReels) {
                this.file = null;
            }
        }

        private ReelFile loadFile() throws Exception {
            return ReelFile.open((File)this.file);
        }

        private ReelFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request(MasterDatamartImpl.this.hasLocalAccessToReels ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get reel " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToReels = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToReels = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get reel " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private ReelFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".reel");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            MasterDatamartImpl.this.hasLocalAccessToReels = false;
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-reel;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }
}

