package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Tag;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class TagMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;
	private boolean useListeners = true;

	public TagMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public TagMounter useListeners(boolean useListeners) {
		this.useListeners = useListeners;
		return this;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled")) {
				if(message.get("enabled").asBoolean()) {
					entities.enable(owner.id());
				} else {
					entities.disable(owner.id());
				}
			}
		}
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.Tag.definition, id);
		if(entity == null) entity = entities.getDisabled(io.intino.cosmos.datahub.datamarts.master.entities.Tag.definition, id);
		if(entity == null) {
			entity = new Tag(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: new Thread(() -> listener.onCreate(entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start(); break;
				case Update: new Thread(() -> listener.onUpdate(entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start(); break;
				case Remove: new Thread(() -> listener.onRemove(entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start(); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
		}
		return message.get(attribute).asString();
	}
}