package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class ServiceMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;
	private boolean useListeners = true;

	public ServiceMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public ServiceMounter useListeners(boolean useListeners) {
		this.useListeners = useListeners;
		return this;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled")) {
				if(message.get("enabled").asBoolean()) {
					entities.enable(owner.id());
				} else {
					entities.disable(owner.id());
				}
			}
		}

		Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
		if(components.containsKey("Operation")) update(owner, "operationList", new Service$OperationStructFactory().create(components.get("Operation")));
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.Service.definition, id);
		if(entity == null) entity = entities.getDisabled(io.intino.cosmos.datahub.datamarts.master.entities.Service.definition, id);
		if(entity == null) {
			entity = new Service(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: new Thread(() -> listener.onCreate(entity), "MasterListener-ServiceMounter-" + System.currentTimeMillis()).start(); break;
				case Update: new Thread(() -> listener.onUpdate(entity), "MasterListener-ServiceMounter-" + System.currentTimeMillis()).start(); break;
				case Remove: new Thread(() -> listener.onRemove(entity), "MasterListener-ServiceMounter-" + System.currentTimeMillis()).start(); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "tags": return parseTags(message);
			case "responsible": return parseResponsible(message);
			case "observer": return parseObserver(message);
			case "container": return parseContainer(message);
			case "model": return parseModel(message);
			case "team": return parseTeam(message);
			case "place": return parsePlace(message);
			case "label": return parseLabel(message);
			case "url": return parseUrl(message);
		}
		return message.get(attribute).asString();
	}

	private java.util.List<String> parseTags(Message m) {
		var value = m.get("tags");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private String parseResponsible(Message m) {
		return m.get("responsible").asString();
	}

	private String parseObserver(Message m) {
		return m.get("observer").asString();
	}

	private String parseContainer(Message m) {
		return m.get("container").asString();
	}

	private String parseModel(Message m) {
		return m.get("model").asString();
	}

	private String parseTeam(Message m) {
		return m.get("team").as(String.class);
	}

	private String parsePlace(Message m) {
		return m.get("place").asString();
	}

	private String parseLabel(Message m) {
		return m.get("label").as(String.class);
	}

	private String parseUrl(Message m) {
		return m.get("url").as(String.class);
	}

	 private class Service$OperationStructFactory {

		private List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation> create(List<Message> components) {
			List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation> structs = new ArrayList<>();
			for(Message component : components) structs.add(create(component));
			return structs;
		}

		private io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation create(Message component) {
			io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation owner = new io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation(entities.datamart());
			for(String attrib : component.attributes()) {
				update(owner, attrib, this.parse(attrib, component));
			}

			Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));
			if(components.containsKey("Procedure")) update(owner, "procedureList", new Service$Operation$ProcedureStructFactory().create(components.get("Procedure")));

			return owner;
		}

	 	private Object parse(String attribute, Message message) {
	    	if(message.get(attribute).isNull()) return null;
	    	switch(attribute) {
	    		case "activity": return parseActivity(message);
	    		case "name": return parseName(message);
	    	}
	    	return message.get(attribute).asString();
	    }

	    private String parseActivity(Message m) {
	    	return m.get("activity").as(String.class);
	    }

	    private String parseName(Message m) {
	    	return m.get("name").as(String.class);
	    }

	     private class Service$Operation$ProcedureStructFactory {

	    	private List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure> create(List<Message> components) {
	    		List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure> structs = new ArrayList<>();
	    		for(Message component : components) structs.add(create(component));
	    		return structs;
	    	}

	    	private io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure create(Message component) {
	    		io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure owner = new io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure(entities.datamart());
	    		for(String attrib : component.attributes()) {
	    			update(owner, attrib, this.parse(attrib, component));
	    		}

	    		Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));
	    		if(components.containsKey("Parameter")) update(owner, "parameterList", new Service$Operation$Procedure$ParameterStructFactory().create(components.get("Parameter")));

	    		return owner;
	    	}

	     	private Object parse(String attribute, Message message) {
	        	if(message.get(attribute).isNull()) return null;
	        	switch(attribute) {
	        		case "name": return parseName(message);
	        		case "returnType": return parseReturnType(message);
	        		case "description": return parseDescription(message);
	        	}
	        	return message.get(attribute).asString();
	        }

	        private String parseName(Message m) {
	        	return m.get("name").as(String.class);
	        }

	        private String parseReturnType(Message m) {
	        	return m.get("returnType").as(String.class);
	        }

	        private String parseDescription(Message m) {
	        	return m.get("description").as(String.class);
	        }

	         private class Service$Operation$Procedure$ParameterStructFactory {

	        	private List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure.Parameter> create(List<Message> components) {
	        		List<io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure.Parameter> structs = new ArrayList<>();
	        		for(Message component : components) structs.add(create(component));
	        		return structs;
	        	}

	        	private io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure.Parameter create(Message component) {
	        		io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure.Parameter owner = new io.intino.cosmos.datahub.datamarts.master.entities.Service.Operation.Procedure.Parameter(entities.datamart());
	        		for(String attrib : component.attributes()) {
	        			update(owner, attrib, this.parse(attrib, component));
	        		}

	        		return owner;
	        	}

	         	private Object parse(String attribute, Message message) {
	            	if(message.get(attribute).isNull()) return null;
	            	switch(attribute) {
	            		case "type": return parseType(message);
	            		case "name": return parseName(message);
	            	}
	            	return message.get(attribute).asString();
	            }

	            private String parseType(Message m) {
	            	return m.get("type").as(String.class);
	            }

	            private String parseName(Message m) {
	            	return m.get("name").as(String.class);
	            }
	         }
	     }
	 }
}