/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Tag;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import java.util.List;
import java.util.Objects;

public class TagMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;
    private boolean useListeners = true;

    public TagMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public TagMounter useListeners(boolean useListeners) {
        this.useListeners = useListeners;
        return this;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip && this.useListeners) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled")) continue;
            if (message.get("enabled").asBoolean().booleanValue()) {
                this.entities.enable(owner.id());
                continue;
            }
            this.entities.disable(owner.id());
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        MasterEntity entity = this.entities.get(Tag.definition, id);
        if (entity == null) {
            entity = this.entities.getDisabled(Tag.definition, id);
        }
        if (entity == null) {
            entity = new Tag(id, this.entities.datamart());
            this.entities.add(entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    new Thread(() -> listener.onCreate((Entity)entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Update: {
                    new Thread(() -> listener.onUpdate((Entity)entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Remove: {
                    new Thread(() -> listener.onRemove((Entity)entity), "MasterListener-TagMounter-" + System.currentTimeMillis()).start();
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        Objects.requireNonNull(attribute);
        return message.get(attribute).asString();
    }
}

