package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class ModelMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;
	private boolean useListeners = true;

	public ModelMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public ModelMounter useListeners(boolean useListeners) {
		this.useListeners = useListeners;
		return this;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled")) {
				if(message.get("enabled").asBoolean()) {
					entities.enable(owner.id());
				} else {
					entities.disable(owner.id());
				}
			}
		}

		Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
		if(components.containsKey("Profile")) update(owner, "profile", new Model$ProfileStructFactory().create(components.get("Profile").get(0)));
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.Model.definition, id);
		if(entity == null) entity = entities.getDisabled(io.intino.cosmos.datahub.datamarts.master.entities.Model.definition, id);
		if(entity == null) {
			entity = new Model(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: new Thread(() -> listener.onCreate(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start(); break;
				case Update: new Thread(() -> listener.onUpdate(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start(); break;
				case Remove: new Thread(() -> listener.onRemove(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start(); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "type": return parseType(message);
			case "target": return parseTarget(message);
		}
		return message.get(attribute).asString();
	}

	private String parseType(Message m) {
		return m.get("type").as(String.class);
	}

	private String parseTarget(Message m) {
		return m.get("target").as(String.class);
	}

	 private class Model$ProfileStructFactory {

		private List<io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile> create(List<Message> components) {
			List<io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile> structs = new ArrayList<>();
			for(Message component : components) structs.add(create(component));
			return structs;
		}

		private io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile create(Message component) {
			io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile owner = new io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile(entities.datamart());
			for(String attrib : component.attributes()) {
				update(owner, attrib, this.parse(attrib, component));
			}

			Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));
			if(components.containsKey("Variable")) update(owner, "variableList", new Model$Profile$VariableStructFactory().create(components.get("Variable")));

			return owner;
		}

	 	private Object parse(String attribute, Message message) {
	    	if(message.get(attribute).isNull()) return null;
	    	switch(attribute) {
	    	}
	    	return message.get(attribute).asString();
	    }

	     private class Model$Profile$VariableStructFactory {

	    	private List<io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile.Variable> create(List<Message> components) {
	    		List<io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile.Variable> structs = new ArrayList<>();
	    		for(Message component : components) structs.add(create(component));
	    		return structs;
	    	}

	    	private io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile.Variable create(Message component) {
	    		io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile.Variable owner = new io.intino.cosmos.datahub.datamarts.master.entities.Model.Profile.Variable(entities.datamart());
	    		for(String attrib : component.attributes()) {
	    			update(owner, attrib, this.parse(attrib, component));
	    		}

	    		return owner;
	    	}

	     	private Object parse(String attribute, Message message) {
	        	if(message.get(attribute).isNull()) return null;
	        	switch(attribute) {
	        		case "name": return parseName(message);
	        		case "className": return parseClassName(message);
	        		case "label": return parseLabel(message);
	        		case "type": return parseType(message);
	        		case "operator": return parseOperator(message);
	        		case "unit": return parseUnit(message);
	        		case "symbol": return parseSymbol(message);
	        		case "values": return parseValues(message);
	        		case "priority": return parsePriority(message);
	        		case "min": return parseMin(message);
	        		case "max": return parseMax(message);
	        		case "description": return parseDescription(message);
	        		case "format": return parseFormat(message);
	        	}
	        	return message.get(attribute).asString();
	        }

	        private String parseName(Message m) {
	        	return m.get("name").as(String.class);
	        }

	        private String parseClassName(Message m) {
	        	return m.get("className").as(String.class);
	        }

	        private String parseLabel(Message m) {
	        	return m.get("label").as(String.class);
	        }

	        private String parseType(Message m) {
	        	return m.get("type").as(String.class);
	        }

	        private String parseOperator(Message m) {
	        	return m.get("operator").as(String.class);
	        }

	        private String parseUnit(Message m) {
	        	return m.get("unit").as(String.class);
	        }

	        private String parseSymbol(Message m) {
	        	return m.get("symbol").as(String.class);
	        }

	        private java.util.List<String> parseValues(Message m) {
	        	var value = m.get("values");
	        	return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	        }

	        private Integer parsePriority(Message m) {
	        	return m.get("priority").as(Integer.class);
	        }

	        private String parseMin(Message m) {
	        	return m.get("min").as(String.class);
	        }

	        private String parseMax(Message m) {
	        	return m.get("max").as(String.class);
	        }

	        private String parseDescription(Message m) {
	        	return m.get("description").as(String.class);
	        }

	        private String parseFormat(Message m) {
	        	return m.get("format").as(String.class);
	        }
	     }
	 }
}