package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class CountermeasureMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;
	private boolean useListeners = true;

	public CountermeasureMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public CountermeasureMounter useListeners(boolean useListeners) {
		this.useListeners = useListeners;
		return this;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled")) {
				if(message.get("enabled").asBoolean()) {
					entities.enable(owner.id());
				} else {
					entities.disable(owner.id());
				}
			}
		}

		Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
		if(components.containsKey("Actuation")) update(owner, "actuationList", new Countermeasure$ActuationStructFactory().create(components.get("Actuation")));
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.definition, id);
		if(entity == null) entity = entities.getDisabled(io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.definition, id);
		if(entity == null) {
			entity = new Countermeasure(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: new Thread(() -> listener.onCreate(entity), "MasterListener-CountermeasureMounter-" + System.currentTimeMillis()).start(); break;
				case Update: new Thread(() -> listener.onUpdate(entity), "MasterListener-CountermeasureMounter-" + System.currentTimeMillis()).start(); break;
				case Remove: new Thread(() -> listener.onRemove(entity), "MasterListener-CountermeasureMounter-" + System.currentTimeMillis()).start(); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "condition": return parseCondition(message);
			case "priority": return parsePriority(message);
		}
		return message.get(attribute).asString();
	}

	private String parseCondition(Message m) {
		return m.get("condition").as(String.class);
	}

	private String parsePriority(Message m) {
		return m.get("priority").as(String.class);
	}

	 private class Countermeasure$ActuationStructFactory {

		private List<io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.Actuation> create(List<Message> components) {
			List<io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.Actuation> structs = new ArrayList<>();
			for(Message component : components) structs.add(create(component));
			return structs;
		}

		private io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.Actuation create(Message component) {
			io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.Actuation owner = new io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure.Actuation(entities.datamart());
			for(String attrib : component.attributes()) {
				update(owner, attrib, this.parse(attrib, component));
			}

			return owner;
		}

	 	private Object parse(String attribute, Message message) {
	    	if(message.get(attribute).isNull()) return null;
	    	switch(attribute) {
	    		case "id": return parseId(message);
	    		case "name": return parseName(message);
	    		case "label": return parseLabel(message);
	    		case "target": return parseTarget(message);
	    		case "tries": return parseTries(message);
	    		case "tryInterval": return parseTryInterval(message);
	    		case "extraCondition": return parseExtraCondition(message);
	    		case "notification": return parseNotification(message);
	    		case "dismissNotification": return parseDismissNotification(message);
	    		case "channels": return parseChannels(message);
	    	}
	    	return message.get(attribute).asString();
	    }

	    private String parseId(Message m) {
	    	return m.get("id").as(String.class);
	    }

	    private String parseName(Message m) {
	    	return m.get("name").as(String.class);
	    }

	    private String parseLabel(Message m) {
	    	return m.get("label").as(String.class);
	    }

	    private String parseTarget(Message m) {
	    	return m.get("target").as(String.class);
	    }

	    private Integer parseTries(Message m) {
	    	return m.get("tries").as(Integer.class);
	    }

	    private Integer parseTryInterval(Message m) {
	    	return m.get("tryInterval").as(Integer.class);
	    }

	    private String parseExtraCondition(Message m) {
	    	return m.get("extraCondition").as(String.class);
	    }

	    private String parseNotification(Message m) {
	    	return m.get("notification").as(String.class);
	    }

	    private String parseDismissNotification(Message m) {
	    	return m.get("dismissNotification").as(String.class);
	    }

	    private java.util.List<String> parseChannels(Message m) {
	    	var value = m.get("channels");
	    	return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	    }
	 }
}