/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import java.util.List;
import java.util.Objects;

public class OrderTypeMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;

    public OrderTypeMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled") || message.get("enabled").asBoolean().booleanValue()) continue;
            operation[0] = operation[0] == MasterMounter.Operation.Create ? MasterMounter.Operation.Skip : MasterMounter.Operation.Remove;
            this.entities.remove(owner.id());
            return;
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        MasterEntity entity = this.entities.get(OrderType.definition, id);
        if (entity == null) {
            entity = new OrderType(id, this.entities.datamart());
            this.entities.add(entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    listener.onCreate((Entity)entity);
                    break;
                }
                case Update: {
                    listener.onUpdate((Entity)entity);
                    break;
                }
                case Remove: {
                    listener.onRemove((Entity)entity);
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        Objects.requireNonNull(attribute);
        return message.get(attribute).asString();
    }
}

