package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class JavaApplicationMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;

	public JavaApplicationMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled") && !message.get("enabled").asBoolean()) {
				operation[0] = operation[0] == Create ? Skip : Remove;
				entities.remove(owner.id());
				return;
			}
		}

		Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
		if(components.containsKey("Operation")) update(owner, "operationList", new JavaApplication$OperationStructFactory().create(components.get("Operation")));
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.definition, id);
		if(entity == null) {
			entity = new JavaApplication(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: listener.onCreate(entity); break;
				case Update: listener.onUpdate(entity); break;
				case Remove: listener.onRemove(entity); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "tags": return parseTags(message);
			case "responsible": return parseResponsible(message);
			case "observer": return parseObserver(message);
			case "container": return parseContainer(message);
			case "model": return parseModel(message);
			case "team": return parseTeam(message);
			case "place": return parsePlace(message);
			case "label": return parseLabel(message);
			case "state": return parseState(message);
			case "commandLine": return parseCommandLine(message);
			case "pid": return parsePid(message);
			case "startingTime": return parseStartingTime(message);
			case "systemService": return parseSystemService(message);
			case "user": return parseUser(message);
			case "name": return parseName(message);
			case "classpathPrefix": return parseClasspathPrefix(message);
			case "mainArtifact": return parseMainArtifact(message);
			case "debugPort": return parseDebugPort(message);
			case "jmxPort": return parseJmxPort(message);
			case "minMemory": return parseMinMemory(message);
			case "maxMemory": return parseMaxMemory(message);
			case "classpath": return parseClasspath(message);
			case "inputArguments": return parseInputArguments(message);
			case "jvmParameter": return parseJvmParameter(message);
			case "jvmVersion": return parseJvmVersion(message);
		}
		return message.get(attribute).asString();
	}

	private java.util.List<String> parseTags(Message m) {
		var value = m.get("tags");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private String parseResponsible(Message m) {
		return m.get("responsible").asString();
	}

	private String parseObserver(Message m) {
		return m.get("observer").asString();
	}

	private String parseContainer(Message m) {
		return m.get("container").asString();
	}

	private String parseModel(Message m) {
		return m.get("model").asString();
	}

	private String parseTeam(Message m) {
		return m.get("team").as(String.class);
	}

	private String parsePlace(Message m) {
		return m.get("place").asString();
	}

	private String parseLabel(Message m) {
		return m.get("label").as(String.class);
	}

	private io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.State parseState(Message m) {
		try {
			return io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.State.valueOf(m.get("state").asString());
		} catch(Exception ignored) {
			return null;
		}
	}

	private String parseCommandLine(Message m) {
		return m.get("commandLine").as(String.class);
	}

	private Integer parsePid(Message m) {
		return m.get("pid").as(Integer.class);
	}

	private static final java.time.format.DateTimeFormatter StartingTimeFormatter = java.time.format.DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
	private LocalDateTime parseStartingTime(Message m) {
		try {
			return LocalDateTime.parse((m.get("startingTime").asString()), StartingTimeFormatter);
		} catch(Exception ignored) {
			return null;
		}
	}

	private String parseSystemService(Message m) {
		return m.get("systemService").as(String.class);
	}

	private String parseUser(Message m) {
		return m.get("user").as(String.class);
	}

	private String parseName(Message m) {
		return m.get("name").as(String.class);
	}

	private String parseClasspathPrefix(Message m) {
		return m.get("classpathPrefix").as(String.class);
	}

	private String parseMainArtifact(Message m) {
		return m.get("mainArtifact").as(String.class);
	}

	private Integer parseDebugPort(Message m) {
		return m.get("debugPort").as(Integer.class);
	}

	private Integer parseJmxPort(Message m) {
		return m.get("jmxPort").as(Integer.class);
	}

	private Integer parseMinMemory(Message m) {
		return m.get("minMemory").as(Integer.class);
	}

	private Integer parseMaxMemory(Message m) {
		return m.get("maxMemory").as(Integer.class);
	}

	private java.util.List<String> parseClasspath(Message m) {
		var value = m.get("classpath");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private java.util.List<String> parseInputArguments(Message m) {
		var value = m.get("inputArguments");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private java.util.List<String> parseJvmParameter(Message m) {
		var value = m.get("jvmParameter");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private String parseJvmVersion(Message m) {
		return m.get("jvmVersion").as(String.class);
	}

	 private class JavaApplication$OperationStructFactory {

		private List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation> create(List<Message> components) {
			List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation> structs = new ArrayList<>();
			for(Message component : components) structs.add(create(component));
			return structs;
		}

		private io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation create(Message component) {
			io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation owner = new io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation(entities.datamart());
			for(String attrib : component.attributes()) {
				update(owner, attrib, this.parse(attrib, component));
			}

			Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));
			if(components.containsKey("Procedure")) update(owner, "procedureList", new JavaApplication$Operation$ProcedureStructFactory().create(components.get("Procedure")));

			return owner;
		}

	 	private Object parse(String attribute, Message message) {
	    	if(message.get(attribute).isNull()) return null;
	    	switch(attribute) {
	    		case "activity": return parseActivity(message);
	    		case "name": return parseName(message);
	    	}
	    	return message.get(attribute).asString();
	    }

	    private String parseActivity(Message m) {
	    	return m.get("activity").as(String.class);
	    }

	    private String parseName(Message m) {
	    	return m.get("name").as(String.class);
	    }

	     private class JavaApplication$Operation$ProcedureStructFactory {

	    	private List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure> create(List<Message> components) {
	    		List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure> structs = new ArrayList<>();
	    		for(Message component : components) structs.add(create(component));
	    		return structs;
	    	}

	    	private io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure create(Message component) {
	    		io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure owner = new io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure(entities.datamart());
	    		for(String attrib : component.attributes()) {
	    			update(owner, attrib, this.parse(attrib, component));
	    		}

	    		Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));
	    		if(components.containsKey("Parameter")) update(owner, "parameterList", new JavaApplication$Operation$Procedure$ParameterStructFactory().create(components.get("Parameter")));

	    		return owner;
	    	}

	     	private Object parse(String attribute, Message message) {
	        	if(message.get(attribute).isNull()) return null;
	        	switch(attribute) {
	        		case "name": return parseName(message);
	        		case "returnType": return parseReturnType(message);
	        		case "description": return parseDescription(message);
	        	}
	        	return message.get(attribute).asString();
	        }

	        private String parseName(Message m) {
	        	return m.get("name").as(String.class);
	        }

	        private String parseReturnType(Message m) {
	        	return m.get("returnType").as(String.class);
	        }

	        private String parseDescription(Message m) {
	        	return m.get("description").as(String.class);
	        }

	         private class JavaApplication$Operation$Procedure$ParameterStructFactory {

	        	private List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure.Parameter> create(List<Message> components) {
	        		List<io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure.Parameter> structs = new ArrayList<>();
	        		for(Message component : components) structs.add(create(component));
	        		return structs;
	        	}

	        	private io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure.Parameter create(Message component) {
	        		io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure.Parameter owner = new io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication.Operation.Procedure.Parameter(entities.datamart());
	        		for(String attrib : component.attributes()) {
	        			update(owner, attrib, this.parse(attrib, component));
	        		}

	        		return owner;
	        	}

	         	private Object parse(String attribute, Message message) {
	            	if(message.get(attribute).isNull()) return null;
	            	switch(attribute) {
	            		case "type": return parseType(message);
	            		case "name": return parseName(message);
	            	}
	            	return message.get(attribute).asString();
	            }

	            private String parseType(Message m) {
	            	return m.get("type").as(String.class);
	            }

	            private String parseName(Message m) {
	            	return m.get("name").as(String.class);
	            }
	         }
	     }
	 }
}