package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class PlaceMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;
	private boolean useListeners = true;

	public PlaceMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public PlaceMounter useListeners(boolean useListeners) {
		this.useListeners = useListeners;
		return this;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled")) {
				if(message.get("enabled").asBoolean()) {
					entities.enable(owner.id());
				} else {
					entities.disable(owner.id());
				}
			}
		}
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.Place.definition, id);
		if(entity == null) entity = entities.getDisabled(io.intino.cosmos.datahub.datamarts.master.entities.Place.definition, id);
		if(entity == null) {
			entity = new Place(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: new Thread(() -> listener.onCreate(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start(); break;
				case Update: new Thread(() -> listener.onUpdate(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start(); break;
				case Remove: new Thread(() -> listener.onRemove(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start(); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "label": return parseLabel(message);
			case "coordinates": return parseCoordinates(message);
			case "timeOffset": return parseTimeOffset(message);
			case "region": return parseRegion(message);
			case "city": return parseCity(message);
			case "area": return parseArea(message);
			case "address": return parseAddress(message);
			case "postalCode": return parsePostalCode(message);
		}
		return message.get(attribute).asString();
	}

	private String parseLabel(Message m) {
		return m.get("label").as(String.class);
	}

	private String parseCoordinates(Message m) {
		return m.get("coordinates").as(String.class);
	}

	private Integer parseTimeOffset(Message m) {
		return m.get("timeOffset").as(Integer.class);
	}

	private String parseRegion(Message m) {
		return m.get("region").as(String.class);
	}

	private String parseCity(Message m) {
		return m.get("city").as(String.class);
	}

	private String parseArea(Message m) {
		return m.get("area").asString();
	}

	private String parseAddress(Message m) {
		return m.get("address").as(String.class);
	}

	private String parsePostalCode(Message m) {
		return m.get("postalCode").as(String.class);
	}
}