/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.mounters.ComputerMounter;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComputerMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;
    private boolean useListeners = true;

    public ComputerMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public ComputerMounter useListeners(boolean useListeners) {
        this.useListeners = useListeners;
        return this;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip && this.useListeners) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled")) continue;
            if (message.get("enabled").asBoolean().booleanValue()) {
                this.entities.enable(owner.id());
                continue;
            }
            this.entities.disable(owner.id());
        }
        Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
        if (components.containsKey("Operation")) {
            this.update(owner, "operationList", new Computer.OperationStructFactory(this).create(components.get("Operation")));
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        MasterEntity entity = this.entities.get(Computer.definition, id);
        if (entity == null) {
            entity = this.entities.getDisabled(Computer.definition, id);
        }
        if (entity == null) {
            entity = new Computer(id, this.entities.datamart());
            this.entities.add(entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    new Thread(() -> listener.onCreate((Entity)entity), "MasterListener-ComputerMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Update: {
                    new Thread(() -> listener.onUpdate((Entity)entity), "MasterListener-ComputerMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Remove: {
                    new Thread(() -> listener.onRemove((Entity)entity), "MasterListener-ComputerMounter-" + System.currentTimeMillis()).start();
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "tags": {
                return this.parseTags(message);
            }
            case "responsible": {
                return this.parseResponsible(message);
            }
            case "observer": {
                return this.parseObserver(message);
            }
            case "container": {
                return this.parseContainer(message);
            }
            case "model": {
                return this.parseModel(message);
            }
            case "team": {
                return this.parseTeam(message);
            }
            case "place": {
                return this.parsePlace(message);
            }
            case "label": {
                return this.parseLabel(message);
            }
            case "publicIp": {
                return this.parsePublicIp(message);
            }
            case "ip": {
                return this.parseIp(message);
            }
            case "sn": {
                return this.parseSn(message);
            }
            case "architecture": {
                return this.parseArchitecture(message);
            }
            case "os": {
                return this.parseOs(message);
            }
            case "cores": {
                return this.parseCores(message);
            }
            case "diskSize": {
                return this.parseDiskSize(message);
            }
            case "memorySize": {
                return this.parseMemorySize(message);
            }
            case "processes": {
                return this.parseProcesses(message);
            }
            case "maxOpenFiles": {
                return this.parseMaxOpenFiles(message);
            }
            case "jvm": {
                return this.parseJvm(message);
            }
            case "isp": {
                return this.parseIsp(message);
            }
        }
        return message.get(attribute).asString();
    }

    private List<String> parseTags(Message m) {
        Message.Value value = m.get("tags");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }

    private String parseResponsible(Message m) {
        return m.get("responsible").asString();
    }

    private String parseObserver(Message m) {
        return m.get("observer").asString();
    }

    private String parseContainer(Message m) {
        return m.get("container").asString();
    }

    private String parseModel(Message m) {
        return m.get("model").asString();
    }

    private String parseTeam(Message m) {
        return (String)m.get("team").as(String.class);
    }

    private String parsePlace(Message m) {
        return m.get("place").asString();
    }

    private String parseLabel(Message m) {
        return (String)m.get("label").as(String.class);
    }

    private String parsePublicIp(Message m) {
        return (String)m.get("publicIp").as(String.class);
    }

    private String parseIp(Message m) {
        return (String)m.get("ip").as(String.class);
    }

    private String parseSn(Message m) {
        return (String)m.get("sn").as(String.class);
    }

    private String parseArchitecture(Message m) {
        return (String)m.get("architecture").as(String.class);
    }

    private String parseOs(Message m) {
        return (String)m.get("os").as(String.class);
    }

    private Integer parseCores(Message m) {
        return (Integer)m.get("cores").as(Integer.class);
    }

    private Long parseDiskSize(Message m) {
        return (Long)m.get("diskSize").as(Long.class);
    }

    private Long parseMemorySize(Message m) {
        return (Long)m.get("memorySize").as(Long.class);
    }

    private Integer parseProcesses(Message m) {
        return (Integer)m.get("processes").as(Integer.class);
    }

    private Long parseMaxOpenFiles(Message m) {
        return (Long)m.get("maxOpenFiles").as(Long.class);
    }

    private String parseJvm(Message m) {
        return (String)m.get("jvm").as(String.class);
    }

    private String parseIsp(Message m) {
        return (String)m.get("isp").as(String.class);
    }
}

