package io.intino.cosmos.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.Json;
import org.apache.activemq.command.ActiveMQTextMessage;
import com.google.gson.JsonObject;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.Collectors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class MonetTerminal {
	public static String[] subscriptionChannels = new String[]{};
	private final io.intino.alexandria.terminal.Connector connector;
	private final java.util.Set<java.util.function.BiConsumer> datamartConsumers = new java.util.HashSet<>();
	private volatile io.intino.alexandria.datalake.Datalake datalake;
	private final DatamartsRetryConfig datamartsRetryConfig;
	private String sourceSelector;
	private final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();
	private volatile io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl datamart;

	public MonetTerminal(io.intino.alexandria.terminal.Connector connector) {
		this(connector, new DatamartsRetryConfig());
	}

	public MonetTerminal(io.intino.alexandria.terminal.Connector connector, DatamartsRetryConfig datamartsRetryConfig) {
		this.connector = connector;
		this.datamartsRetryConfig = datamartsRetryConfig;
		this.datamart = new io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl(connector, datamartsRetryConfig);
	}

	public io.intino.cosmos.datahub.datamarts.master.MasterDatamart datamart() {
		return datamart;
	}


	public void initDatamarts() {
		initDatamarts(null);
	}

	public void initDatamarts(String sourceSelector) {
		this.sourceSelector = sourceSelector;
		datamart.init(sourceSelector);
		addDatamartSubscribers(sourceSelector);
	}

	public void publish(Event event) {
		switch (event.type()) {
			case "Assertion": publish((event instanceof io.intino.cosmos.datahub.messages.actuation.Assertion e ? e : new io.intino.cosmos.datahub.messages.actuation.Assertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "OrderStarted": publish((event instanceof io.intino.cosmos.datahub.messages.actuation.OrderStarted e ? e : new io.intino.cosmos.datahub.messages.actuation.OrderStarted(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "OrderFinished": publish((event instanceof io.intino.cosmos.datahub.messages.actuation.OrderFinished e ? e : new io.intino.cosmos.datahub.messages.actuation.OrderFinished(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "OrderCancelled": publish((event instanceof io.intino.cosmos.datahub.messages.actuation.OrderCancelled e ? e : new io.intino.cosmos.datahub.messages.actuation.OrderCancelled(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			default: Logger.warn(getClass().getSimpleName() + " is not configured to publish " + event.type() + " events.");
		}
	}

	public void publish(Event first, Event ...others) {
		publish(Stream.concat(Stream.of(first), java.util.Arrays.stream(others)));
	}

	public void publish(Event[] events) {
		publish(java.util.Arrays.stream(events));
	}

	public void publish(java.util.Collection<Event> events) {
		publish(events.stream());
	}

	public void publish(Stream<Event> events) {
		events.filter(e -> channelOf(e.type()) != null)
			.collect(Collectors.groupingBy(Event::type))
			.forEach((type, eventList) -> connector.sendEvents(channelOf(type), eventList));
	}

	public synchronized io.intino.alexandria.datalake.Datalake datalake() {
		return datalake != null ? datalake : (datalake = instantiateDatalake());
	}

	private io.intino.alexandria.datalake.Datalake instantiateDatalake() {
		try {
			Message message = connector.requestResponse(io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor.PATH, request("Datalake"), 5, TimeUnit.SECONDS);
			if (message == null) return null;
			String path = ((TextMessage) message).getText();
			if (path == null) return null;
			return new File(path).exists()
					? new io.intino.alexandria.datalake.file.FileDatalake(new File(path))
					: new io.intino.alexandria.terminal.remotedatalake.RemoteDatalake((io.intino.alexandria.terminal.JmsConnector) connector);
		} catch (JMSException e) {
			Logger.error(e);
			return null;
		}
	}

	public BatchSession batch(java.io.File temporalStageDirectory) {
		return new BatchSession(temporalStageDirectory);
	}

	public BatchSession batch(java.io.File temporalStageDirectory, Config config) {
		return new BatchSession(temporalStageDirectory, config);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.Assertion e) {
		connector.sendEvent("actuation.Assertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.Assertion first, io.intino.cosmos.datahub.messages.actuation.Assertion ...others) {
		io.intino.cosmos.datahub.messages.actuation.Assertion[] array = new io.intino.cosmos.datahub.messages.actuation.Assertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.Assertion[] events) {
		connector.sendEvents("actuation.Assertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderStarted e) {
		connector.sendEvent("actuation.OrderStarted", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderStarted first, io.intino.cosmos.datahub.messages.actuation.OrderStarted ...others) {
		io.intino.cosmos.datahub.messages.actuation.OrderStarted[] array = new io.intino.cosmos.datahub.messages.actuation.OrderStarted[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderStarted[] events) {
		connector.sendEvents("actuation.OrderStarted", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderFinished e) {
		connector.sendEvent("actuation.OrderFinished", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderFinished first, io.intino.cosmos.datahub.messages.actuation.OrderFinished ...others) {
		io.intino.cosmos.datahub.messages.actuation.OrderFinished[] array = new io.intino.cosmos.datahub.messages.actuation.OrderFinished[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderFinished[] events) {
		connector.sendEvents("actuation.OrderFinished", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderCancelled e) {
		connector.sendEvent("actuation.OrderCancelled", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderCancelled first, io.intino.cosmos.datahub.messages.actuation.OrderCancelled ...others) {
		io.intino.cosmos.datahub.messages.actuation.OrderCancelled[] array = new io.intino.cosmos.datahub.messages.actuation.OrderCancelled[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.actuation.OrderCancelled[] events) {
		connector.sendEvents("actuation.OrderCancelled", java.util.Arrays.asList(events));
	}

	public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.Assertion((MessageEvent) event), "actuation.Assertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.Assertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.Assertion((MessageEvent) event), "actuation.Assertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.Assertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.Assertion((MessageEvent) event), "actuation.Assertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.Assertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(ActuationAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.Assertion((MessageEvent) event), "actuation.Assertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.Assertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ActuationAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(ActuationOrderStartedConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderStarted((MessageEvent) event), "actuation.OrderStarted");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderStarted", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ActuationOrderStartedConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderStarted((MessageEvent) event), "actuation.OrderStarted");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderStarted", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(ActuationOrderStartedConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderStarted((MessageEvent) event), "actuation.OrderStarted");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderStarted", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(ActuationOrderStartedConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderStarted((MessageEvent) event), "actuation.OrderStarted");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderStarted", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ActuationOrderStartedConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(ActuationOrderFinishedConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderFinished((MessageEvent) event), "actuation.OrderFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderFinished", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ActuationOrderFinishedConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderFinished((MessageEvent) event), "actuation.OrderFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderFinished", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(ActuationOrderFinishedConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderFinished((MessageEvent) event), "actuation.OrderFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderFinished", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(ActuationOrderFinishedConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderFinished((MessageEvent) event), "actuation.OrderFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderFinished", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ActuationOrderFinishedConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(ActuationOrderCancelledConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderCancelled((MessageEvent) event), "actuation.OrderCancelled");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderCancelled", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ActuationOrderCancelledConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderCancelled((MessageEvent) event), "actuation.OrderCancelled");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderCancelled", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(ActuationOrderCancelledConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderCancelled((MessageEvent) event), "actuation.OrderCancelled");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderCancelled", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(ActuationOrderCancelledConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.actuation.OrderCancelled((MessageEvent) event), "actuation.OrderCancelled");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("actuation.OrderCancelled", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ActuationOrderCancelledConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePlaceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseAreaAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseTagAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseModelAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePersonAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseProcessAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseAssetAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePartAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseHardwareAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplianceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseComputerAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseObserverAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseServiceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplicationAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringSwitchConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringWirelessConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(AnalysisAnalysisConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringComputerConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringApplicationConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringCellularGatewayConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringCameraConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringIncidentConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringStatusConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public synchronized List<MetaMessage> metamodel() {
		Message response = connector.requestResponse("service.ness.metamodel", request("Metamodel"), 10, TimeUnit.SECONDS);
		if (response == null) return null;
		try {
			return Json.fromJson(((TextMessage) response).getText(), new com.google.gson.reflect.TypeToken<java.util.ArrayList<MetaMessage>>() {}.getType());
		} catch (Exception e) {
			Logger.error(e);
			return null;
		}
	}

	public record MetaMessage(String name, boolean assertion, boolean multiple, List<MetaAttribute> attributes, List<MetaMessage> components, List<String> hierarchy){

	}
	public record MetaAttribute(String name, String type) {

	}

	public synchronized void requestSeal() {
		connector.requestResponse("service.ness.seal", request("Seal"), 30, TimeUnit.MINUTES);
	}

	public synchronized Instant requestLastSeal() {
		Message message = connector.requestResponse("service.ness.seal.last", request("LastSeal"), 10, TimeUnit.MINUTES);
		if (message == null) return Instant.now();
		try {
			return Instant.parse(((TextMessage) message).getText());
		} catch (Exception e) {
			Logger.error(e);
			return Instant.now();
		}
	}

	private jakarta.jms.Message request(String type) {
		return request(type, Collections.emptyMap());
	}

	private jakarta.jms.Message request(String type, Map<String, String> attributes) {
		try {
			ActiveMQTextMessage m = new ActiveMQTextMessage();
			io.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);
			attributes.forEach(message::set);
			m.setText(message.toString());
			return m;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	private void addDatamartSubscribers(String sourceSelector) {
		addDatamartEventSubscribers(sourceSelector,  ts -> ts.isAfter(datamart.ts()));
		if (datamart.requiresDatahubNotifications())
			connector.attachListener("service.ness.datamarts.notifications", null, (m, c) -> new Thread(() -> manageDatamartMessage(m)).start());
		connector.attachListener("service.ness.datamarts", null, (m, c) -> new Thread(() -> manageDatamartMessage(m)).start());
	}

	private void addDatamartEventSubscribers(String sourceSelector, java.util.function.Predicate<Instant> predicate) {
		this.datamartConsumers.clear();
		java.util.function.BiConsumer subscriber;
		subscriber = (UniverseTagAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseTagAssertionConsumer) subscriber, connector.clientId() + "_master_TagAssertion", predicate, sourceSelector);
		subscriber = (UniversePlaceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePlaceAssertionConsumer) subscriber, connector.clientId() + "_master_PlaceAssertion", predicate, sourceSelector);
		subscriber = (UniverseIncidentRuleAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseIncidentRuleAssertionConsumer) subscriber, connector.clientId() + "_master_IncidentRuleAssertion", predicate, sourceSelector);
		subscriber = (UniversePartAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePartAssertionConsumer) subscriber, connector.clientId() + "_master_PartAssertion", predicate, sourceSelector);
		subscriber = (UniverseComputerAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseComputerAssertionConsumer) subscriber, connector.clientId() + "_master_ComputerAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplicationAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplicationAssertionConsumer) subscriber, connector.clientId() + "_master_ApplicationAssertion", predicate, sourceSelector);
		subscriber = (UniverseProcessAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseProcessAssertionConsumer) subscriber, connector.clientId() + "_master_ProcessAssertion", predicate, sourceSelector);
		subscriber = (UniverseSoftwareAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseSoftwareAssertionConsumer) subscriber, connector.clientId() + "_master_SoftwareAssertion", predicate, sourceSelector);
		subscriber = (UniverseObserverAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseObserverAssertionConsumer) subscriber, connector.clientId() + "_master_ObserverAssertion", predicate, sourceSelector);
		subscriber = (UniverseHardwareAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseHardwareAssertionConsumer) subscriber, connector.clientId() + "_master_HardwareAssertion", predicate, sourceSelector);
		subscriber = (UniverseAreaAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseAreaAssertionConsumer) subscriber, connector.clientId() + "_master_AreaAssertion", predicate, sourceSelector);
		subscriber = (UniverseCountermeasureAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseCountermeasureAssertionConsumer) subscriber, connector.clientId() + "_master_CountermeasureAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplianceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplianceAssertionConsumer) subscriber, connector.clientId() + "_master_ApplianceAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplicationJavaAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplicationJavaAssertionConsumer) subscriber, connector.clientId() + "_master_ApplicationJavaAssertion", predicate, sourceSelector);
		subscriber = (UniverseModelAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseModelAssertionConsumer) subscriber, connector.clientId() + "_master_ModelAssertion", predicate, sourceSelector);
		subscriber = (UniversePersonAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePersonAssertionConsumer) subscriber, connector.clientId() + "_master_PersonAssertion", predicate, sourceSelector);
		subscriber = (UniverseAssetAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseAssetAssertionConsumer) subscriber, connector.clientId() + "_master_AssetAssertion", predicate, sourceSelector);
		subscriber = (UniverseOrderTypeAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseOrderTypeAssertionConsumer) subscriber, connector.clientId() + "_master_OrderTypeAssertion", predicate, sourceSelector);
		subscriber = (UniverseServiceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseServiceAssertionConsumer) subscriber, connector.clientId() + "_master_ServiceAssertion", predicate, sourceSelector);
	}

	private final Object monitor = new Object();

	private synchronized void manageDatamartMessage(String message) {
		synchronized(monitor) {
			JsonObject jsonObject = Json.fromJson(message, JsonObject.class);
			String operation = jsonObject.getAsJsonPrimitive("operation").getAsString();
			if (operation.equals("reload")) {
				this.datamartConsumers.forEach(c -> consumers.get(c).forEach(connector::detachListeners));
				datamart.init(this.sourceSelector);
				addDatamartEventSubscribers(this.sourceSelector, ts -> ts.isAfter(datamart.ts()));
			} else if (operation.equals("refresh"))
				jsonObject.get("changes").getAsJsonArray().asList().stream()
					.map(e -> e.getAsString())
					.forEach(datamart::handleDatahubNotification);
		}
	}

	private String channelOf(String type) {
		return switch(type) {
			case "Assertion" -> "actuation.Assertion";
			case "OrderStarted" -> "actuation.OrderStarted";
			case "OrderFinished" -> "actuation.OrderFinished";
			case "OrderCancelled" -> "actuation.OrderCancelled";
			default -> null;
		};
	}

	public class BatchSession {
		private final java.io.File temporalStage;
		private final io.intino.alexandria.ingestion.SessionHandler sessionHandler;
		private final io.intino.alexandria.ingestion.EventSession session;
		private final Scale scale;

		public BatchSession(java.io.File temporalStage) {
			this(temporalStage, new Config());
		}

		public BatchSession(java.io.File temporalStage, Config config) {
			this.temporalStage = temporalStage;
			this.scale = config.scale;
			this.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);
			this.session = sessionHandler.createEventSession(config.eventsBufferSize);
		}

		public void feed(Event event) throws java.io.IOException {
			session.put(tankOf(event), event.ss(), Timetag.of(event.ts(), this.scale), event.format(), event);
		}

		public void feed(Event event, Scale scale) throws java.io.IOException {
			session.put(tankOf(event), event.ss(), Timetag.of(event.ts(), scale), event.format(), event);
		}

		public void flush() {
			session.flush();
		}

		public void push(File dataHubStage) {
			session.close();
			sessionHandler.pushTo(dataHubStage);
			//connector.sendEvent("service.ness.push", new Event(new io.intino.alexandria.message.Message("Push").set("stage", temporalStage.getName())));
		}

		public void push(String host, String user, String dataHubStageAbsolutePath) {
			session.close();
			try {
				List<File> files = allFilesIn(temporalStage.toPath(), path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());
				upload(files, host, user, dataHubStageAbsolutePath);
				temporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + ".treated"));
			} catch(Exception e) {
				Logger.error(e);
			}
		}

		private static Stream<File> allFilesIn(java.nio.file.Path path, java.util.function.Predicate<File> filter) throws Exception {
			Stream.Builder<File> streamBuilder = Stream.builder();
			try (Stream<java.nio.file.Path> paths = java.nio.file.Files.walk(path)) {
				paths.filter(p -> java.nio.file.Files.isRegularFile(p) && filter.test(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));
			}
			return streamBuilder.build();
		}

		public synchronized void seal() {
			connector.requestResponse("service.ness.seal", request("Seal", Map.of("stage", temporalStage.getName())));
		}

		private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
			try {
				String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
				Logger.info("Uploading sessions to " + connectionChain + "...");
				for (File s : sessions) {
					Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain)
							.inheritIO()
							.start();
					process.waitFor(1, java.util.concurrent.TimeUnit.HOURS);
				}
				Logger.info("sessions uploaded");
			} catch (java.io.IOException | InterruptedException ignored) {
			}

		}

		private String tankOf(Event event) {
			if (event instanceof io.intino.cosmos.datahub.messages.actuation.Assertion) return "actuation.Assertion";
			if (event instanceof io.intino.cosmos.datahub.messages.actuation.OrderStarted) return "actuation.OrderStarted";
			if (event instanceof io.intino.cosmos.datahub.messages.actuation.OrderFinished) return "actuation.OrderFinished";
			if (event instanceof io.intino.cosmos.datahub.messages.actuation.OrderCancelled) return "actuation.OrderCancelled";
			return event.type();
		}
	}

	public static class Config {
		private int eventsBufferSize = 1_000_000;
		private int setsBufferSize = 1_000_000;
		private Scale scale = Scale.Day;

		public Config scale(Scale scale) {
			this.scale = scale;
			return this;
		}

		public Config eventsBufferSize(int eventsBufferSize) {
			this.eventsBufferSize = eventsBufferSize;
			return this;
		}

		public Config setsBufferSize(int setsBufferSize) {
			this.setsBufferSize = setsBufferSize;
			return this;
		}
	}

	public interface UniverseApplianceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplianceAssertion, String> {
	}

	public interface UniverseApplicationJavaAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion, String> {
	}

	public interface UniverseAssetAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.AssetAssertion, String> {
	}

	public interface UniverseServiceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ServiceAssertion, String> {
	}

	public interface ActuationAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.actuation.Assertion, String> {
	}

	public interface UniverseIncidentRuleAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion, String> {
	}

	public interface UniverseCountermeasureAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion, String> {
	}

	public interface UniverseSoftwareAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.SoftwareAssertion, String> {
	}

	public interface UniversePlaceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PlaceAssertion, String> {
	}

	public interface UniversePersonAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PersonAssertion, String> {
	}

	public interface MonitoringIncidentFinishedConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.IncidentFinished, String> {
	}

	public interface UniverseObserverAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ObserverAssertion, String> {
	}

	public interface ActuationOrderFinishedConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.actuation.OrderFinished, String> {
	}

	public interface MonitoringStatusConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.Status, String> {
	}

	public interface UniverseComputerAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ComputerAssertion, String> {
	}

	public interface UniverseModelAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ModelAssertion, String> {
	}

	public interface UniverseAreaAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.AreaAssertion, String> {
	}

	public interface UniversePartAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PartAssertion, String> {
	}

	public interface ActuationOrderCancelledConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.actuation.OrderCancelled, String> {
	}

	public interface MonitoringIncidentConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.Incident, String> {
	}

	public interface UniverseTagAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.TagAssertion, String> {
	}

	public interface ActuationOrderStartedConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.actuation.OrderStarted, String> {
	}

	public interface UniverseHardwareAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.HardwareAssertion, String> {
	}

	public interface UniverseOrderTypeAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion, String> {
	}

	public interface UniverseProcessAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ProcessAssertion, String> {
	}

	public interface UniverseApplicationAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplicationAssertion, String> {
	}
	public interface MonitoringCameraConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Camera, String> {
	}

	public interface MonitoringSwitchConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Switch, String> {
	}

	public interface MonitoringComputerConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Computer, String> {
	}

	public interface MonitoringCellularGatewayConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.CellularGateway, String> {
	}

	public interface MonitoringWirelessConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Wireless, String> {
	}

	public interface MonitoringApplicationConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Application, String> {
	}

	public interface AnalysisAnalysisConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.analysis.Analysis, String> {
	}



	public static class DatamartsRetryConfig {
		public final long initialTimeoutAmount;
		public final java.util.concurrent.TimeUnit timeoutUnit;
		public final float timeoutMultiplier;
		public final int maxAttempts;

		public DatamartsRetryConfig() {
			this(1, java.util.concurrent.TimeUnit.MINUTES, 2.0f, 5);
		}

		public DatamartsRetryConfig(long initialTimeoutAmount, java.util.concurrent.TimeUnit timeoutUnit, float timeoutMultiplier, int maxAttempts) {
			this.initialTimeoutAmount = initialTimeoutAmount;
			this.timeoutUnit = timeoutUnit;
			this.timeoutMultiplier = timeoutMultiplier;
			this.maxAttempts = maxAttempts;
		}
	}
}