package io.intino.cosmos.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.Json;
import org.apache.activemq.command.ActiveMQTextMessage;
import com.google.gson.JsonObject;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.Collectors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class MasterTerminal {
	public static String[] subscriptionChannels = new String[]{};
	private final io.intino.alexandria.terminal.Connector connector;
	private final java.util.Set<java.util.function.BiConsumer> datamartConsumers = new java.util.HashSet<>();
	private volatile io.intino.alexandria.datalake.Datalake datalake;
	private final DatamartsRetryConfig datamartsRetryConfig;
	private String sourceSelector;
	private final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();
	private volatile io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl datamart;

	public MasterTerminal(io.intino.alexandria.terminal.Connector connector) {
		this(connector, new DatamartsRetryConfig());
	}

	public MasterTerminal(io.intino.alexandria.terminal.Connector connector, DatamartsRetryConfig datamartsRetryConfig) {
		this.connector = connector;
		this.datamartsRetryConfig = datamartsRetryConfig;
		this.datamart = new io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl(connector, datamartsRetryConfig);
	}

	public io.intino.cosmos.datahub.datamarts.master.MasterDatamart datamart() {
		return datamart;
	}


	public void initDatamarts() {
		initDatamarts(null);
	}

	public void initDatamarts(String sourceSelector) {
		this.sourceSelector = sourceSelector;
		datamart.init(sourceSelector);
		addDatamartSubscribers(sourceSelector);
	}

	public void publish(Event event) {
		switch (event.type()) {
			case "Status": publish((event instanceof io.intino.cosmos.datahub.messages.monitoring.Status e ? e : new io.intino.cosmos.datahub.messages.monitoring.Status(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "AreaAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.AreaAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.AreaAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "PartAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.PartAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.PartAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "AssetAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.AssetAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.AssetAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "HardwareAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.HardwareAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.HardwareAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ApplianceAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ApplianceAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ComputerAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ComputerAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ComputerAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "SoftwareAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.SoftwareAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ObserverAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ObserverAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ObserverAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ServiceAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ServiceAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ServiceAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ProcessAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ProcessAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ProcessAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "PersonAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.PersonAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.PersonAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ApplicationAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ApplicationAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "ApplicationJavaAssertion": publish((event instanceof io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion e ? e : new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "Computer": publish((event instanceof io.intino.cosmos.datahub.measurements.monitoring.Computer e ? e : new io.intino.cosmos.datahub.measurements.monitoring.Computer(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "Application": publish((event instanceof io.intino.cosmos.datahub.measurements.monitoring.Application e ? e : new io.intino.cosmos.datahub.measurements.monitoring.Application(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			case "RdbmsStatement": publish((event instanceof io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement e ? e : new io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;
			default: Logger.warn(getClass().getSimpleName() + " is not configured to publish " + event.type() + " events.");
		}
	}

	public void publish(Event first, Event ...others) {
		publish(Stream.concat(Stream.of(first), java.util.Arrays.stream(others)));
	}

	public void publish(Event[] events) {
		publish(java.util.Arrays.stream(events));
	}

	public void publish(java.util.Collection<Event> events) {
		publish(events.stream());
	}

	public void publish(Stream<Event> events) {
		events.filter(e -> channelOf(e.type()) != null)
			.collect(Collectors.groupingBy(Event::type))
			.forEach((type, eventList) -> connector.sendEvents(channelOf(type), eventList));
	}

	public synchronized io.intino.alexandria.datalake.Datalake datalake() {
		return datalake != null ? datalake : (datalake = instantiateDatalake());
	}

	private io.intino.alexandria.datalake.Datalake instantiateDatalake() {
		try {
			Message message = connector.requestResponse(io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor.PATH, request("Datalake"), 5, TimeUnit.SECONDS);
			if (message == null) return null;
			String path = ((TextMessage) message).getText();
			if (path == null) return null;
			return new File(path).exists()
					? new io.intino.alexandria.datalake.file.FileDatalake(new File(path))
					: new io.intino.alexandria.terminal.remotedatalake.RemoteDatalake((io.intino.alexandria.terminal.JmsConnector) connector);
		} catch (JMSException e) {
			Logger.error(e);
			return null;
		}
	}

	public BatchSession batch(java.io.File temporalStageDirectory) {
		return new BatchSession(temporalStageDirectory);
	}

	public BatchSession batch(java.io.File temporalStageDirectory, Config config) {
		return new BatchSession(temporalStageDirectory, config);
	}

	public void publish(io.intino.cosmos.datahub.messages.monitoring.Status e) {
		connector.sendEvent("monitoring.Status", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.monitoring.Status first, io.intino.cosmos.datahub.messages.monitoring.Status ...others) {
		io.intino.cosmos.datahub.messages.monitoring.Status[] array = new io.intino.cosmos.datahub.messages.monitoring.Status[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.monitoring.Status[] events) {
		connector.sendEvents("monitoring.Status", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AreaAssertion e) {
		connector.sendEvent("universe.AreaAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AreaAssertion first, io.intino.cosmos.datahub.messages.universe.AreaAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.AreaAssertion[] array = new io.intino.cosmos.datahub.messages.universe.AreaAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AreaAssertion[] events) {
		connector.sendEvents("universe.AreaAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PartAssertion e) {
		connector.sendEvent("universe.PartAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PartAssertion first, io.intino.cosmos.datahub.messages.universe.PartAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.PartAssertion[] array = new io.intino.cosmos.datahub.messages.universe.PartAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PartAssertion[] events) {
		connector.sendEvents("universe.PartAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AssetAssertion e) {
		connector.sendEvent("universe.AssetAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AssetAssertion first, io.intino.cosmos.datahub.messages.universe.AssetAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.AssetAssertion[] array = new io.intino.cosmos.datahub.messages.universe.AssetAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.AssetAssertion[] events) {
		connector.sendEvents("universe.AssetAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.HardwareAssertion e) {
		connector.sendEvent("universe.HardwareAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.HardwareAssertion first, io.intino.cosmos.datahub.messages.universe.HardwareAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.HardwareAssertion[] array = new io.intino.cosmos.datahub.messages.universe.HardwareAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.HardwareAssertion[] events) {
		connector.sendEvents("universe.HardwareAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplianceAssertion e) {
		connector.sendEvent("universe.ApplianceAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplianceAssertion first, io.intino.cosmos.datahub.messages.universe.ApplianceAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ApplianceAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplianceAssertion[] events) {
		connector.sendEvents("universe.ApplianceAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ComputerAssertion e) {
		connector.sendEvent("universe.ComputerAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ComputerAssertion first, io.intino.cosmos.datahub.messages.universe.ComputerAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ComputerAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ComputerAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ComputerAssertion[] events) {
		connector.sendEvents("universe.ComputerAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.SoftwareAssertion e) {
		connector.sendEvent("universe.SoftwareAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.SoftwareAssertion first, io.intino.cosmos.datahub.messages.universe.SoftwareAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.SoftwareAssertion[] array = new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.SoftwareAssertion[] events) {
		connector.sendEvents("universe.SoftwareAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ObserverAssertion e) {
		connector.sendEvent("universe.ObserverAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ObserverAssertion first, io.intino.cosmos.datahub.messages.universe.ObserverAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ObserverAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ObserverAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ObserverAssertion[] events) {
		connector.sendEvents("universe.ObserverAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ServiceAssertion e) {
		connector.sendEvent("universe.ServiceAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ServiceAssertion first, io.intino.cosmos.datahub.messages.universe.ServiceAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ServiceAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ServiceAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ServiceAssertion[] events) {
		connector.sendEvents("universe.ServiceAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ProcessAssertion e) {
		connector.sendEvent("universe.ProcessAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ProcessAssertion first, io.intino.cosmos.datahub.messages.universe.ProcessAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ProcessAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ProcessAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ProcessAssertion[] events) {
		connector.sendEvents("universe.ProcessAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PersonAssertion e) {
		connector.sendEvent("universe.PersonAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PersonAssertion first, io.intino.cosmos.datahub.messages.universe.PersonAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.PersonAssertion[] array = new io.intino.cosmos.datahub.messages.universe.PersonAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.PersonAssertion[] events) {
		connector.sendEvents("universe.PersonAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationAssertion e) {
		connector.sendEvent("universe.ApplicationAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationAssertion first, io.intino.cosmos.datahub.messages.universe.ApplicationAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ApplicationAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationAssertion[] events) {
		connector.sendEvents("universe.ApplicationAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion e) {
		connector.sendEvent("universe.ApplicationJavaAssertion", e);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion first, io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion ...others) {
		io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion[] array = new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion[1 + others.length];
		array[0] = first;
		java.lang.System.arraycopy(others, 0, array, 1, others.length);
		publish(array);
	}

	public void publish(io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion[] events) {
		connector.sendEvents("universe.ApplicationJavaAssertion", java.util.Arrays.asList(events));
	}

	public void publish(io.intino.cosmos.datahub.measurements.monitoring.Computer e) {
		connector.sendEvent("monitoring.Computer", e);
	}

	public void publish(io.intino.cosmos.datahub.measurements.monitoring.Application e) {
		connector.sendEvent("monitoring.Application", e);
	}

	public void publish(io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement e) {
		connector.sendEvent("monitoring.RdbmsStatement", e);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringStatusConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Status((MessageEvent) event), "monitoring.Status");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Status", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringStatusConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePlaceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PlaceAssertion((MessageEvent) event), "universe.PlaceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PlaceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePlaceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseAreaAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AreaAssertion((MessageEvent) event), "universe.AreaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AreaAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseAreaAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseTagAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.TagAssertion((MessageEvent) event), "universe.TagAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.TagAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseTagAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion((MessageEvent) event), "universe.IncidentRuleAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.IncidentRuleAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion((MessageEvent) event), "universe.CountermeasureAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.CountermeasureAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseModelAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ModelAssertion((MessageEvent) event), "universe.ModelAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ModelAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseModelAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion((MessageEvent) event), "universe.OrderTypeAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.OrderTypeAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePersonAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PersonAssertion((MessageEvent) event), "universe.PersonAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PersonAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePersonAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseProcessAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ProcessAssertion((MessageEvent) event), "universe.ProcessAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ProcessAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseProcessAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseAssetAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.AssetAssertion((MessageEvent) event), "universe.AssetAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.AssetAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseAssetAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniversePartAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.PartAssertion((MessageEvent) event), "universe.PartAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.PartAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniversePartAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseHardwareAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.HardwareAssertion((MessageEvent) event), "universe.HardwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.HardwareAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseHardwareAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplianceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplianceAssertion((MessageEvent) event), "universe.ApplianceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplianceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplianceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseComputerAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ComputerAssertion((MessageEvent) event), "universe.ComputerAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ComputerAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseComputerAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.SoftwareAssertion((MessageEvent) event), "universe.SoftwareAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.SoftwareAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseObserverAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ObserverAssertion((MessageEvent) event), "universe.ObserverAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ObserverAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseObserverAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseServiceAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ServiceAssertion((MessageEvent) event), "universe.ServiceAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ServiceAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseServiceAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseQueryAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.QueryAssertion((MessageEvent) event), "universe.QueryAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.QueryAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseQueryAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.QueryAssertion((MessageEvent) event), "universe.QueryAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.QueryAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseQueryAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.QueryAssertion((MessageEvent) event), "universe.QueryAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.QueryAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseQueryAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.QueryAssertion((MessageEvent) event), "universe.QueryAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.QueryAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseQueryAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplicationAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationAssertion((MessageEvent) event), "universe.ApplicationAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplicationAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion((MessageEvent) event), "universe.ApplicationJavaAssertion");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("universe.ApplicationJavaAssertion", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringSwitchConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Switch(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Switch) event, "monitoring.Switch");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Switch", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringSwitchConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringWirelessConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Wireless(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Wireless) event, "monitoring.Wireless");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Wireless", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringWirelessConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringCameraConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Camera(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Camera) event, "monitoring.Camera");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Camera", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringCameraConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.IncidentFinished((MessageEvent) event), "monitoring.IncidentFinished");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.IncidentFinished", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringIncidentConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cosmos.datahub.messages.monitoring.Incident((MessageEvent) event), "monitoring.Incident");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Incident", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringIncidentConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringRdbmsStatementConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement) event, "monitoring.RdbmsStatement");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.RdbmsStatement", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringRdbmsStatementConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement) event, "monitoring.RdbmsStatement");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.RdbmsStatement", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringRdbmsStatementConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement) event, "monitoring.RdbmsStatement");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.RdbmsStatement", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringRdbmsStatementConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement) event, "monitoring.RdbmsStatement");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.RdbmsStatement", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringRdbmsStatementConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringApplicationConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Application(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Application) event, "monitoring.Application");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Application", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringApplicationConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringComputerConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.Computer(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.Computer) event, "monitoring.Computer");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.Computer", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringComputerConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(MonitoringCellularGatewayConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.monitoring.CellularGateway(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.monitoring.CellularGateway) event, "monitoring.CellularGateway");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("monitoring.CellularGateway", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(MonitoringCellularGatewayConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, String sourceSelector) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", subscriberId, consumers.get(onEventReceived).get(0), filter, sourceSelector);
	}

	public void subscribe(AnalysisAnalysisConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(event instanceof MessageEvent ? new io.intino.cosmos.datahub.measurements.analysis.Analysis(((MessageEvent) event).toMessage()) : (io.intino.cosmos.datahub.measurements.analysis.Analysis) event, "analysis.Analysis");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("analysis.Analysis", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(AnalysisAnalysisConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(connector::detachListeners);
	}

	public synchronized List<MetaMessage> metamodel() {
		Message response = connector.requestResponse("service.ness.metamodel", request("Metamodel"), 10, TimeUnit.SECONDS);
		if (response == null) return null;
		try {
			return Json.fromJson(((TextMessage) response).getText(), new com.google.gson.reflect.TypeToken<java.util.ArrayList<MetaMessage>>() {}.getType());
		} catch (Exception e) {
			Logger.error(e);
			return null;
		}
	}

	public record MetaMessage(String name, boolean assertion, boolean multiple, List<MetaAttribute> attributes, List<MetaMessage> components, List<String> hierarchy){

	}
	public record MetaAttribute(String name, String type) {

	}

	public synchronized void requestSeal() {
		connector.requestResponse("service.ness.seal", request("Seal"), 30, TimeUnit.MINUTES);
	}

	public synchronized Instant requestLastSeal() {
		Message message = connector.requestResponse("service.ness.seal.last", request("LastSeal"), 10, TimeUnit.MINUTES);
		if (message == null) return Instant.now();
		try {
			return Instant.parse(((TextMessage) message).getText());
		} catch (Exception e) {
			Logger.error(e);
			return Instant.now();
		}
	}

	private jakarta.jms.Message request(String type) {
		return request(type, Collections.emptyMap());
	}

	private jakarta.jms.Message request(String type, Map<String, String> attributes) {
		try {
			ActiveMQTextMessage m = new ActiveMQTextMessage();
			io.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);
			attributes.forEach(message::set);
			m.setText(message.toString());
			return m;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	private void addDatamartSubscribers(String sourceSelector) {
		addDatamartEventSubscribers(sourceSelector,  ts -> ts.isAfter(datamart.ts()));
		if (datamart.requiresDatahubNotifications())
			connector.attachListener("service.ness.datamarts.notifications", null, (m, c) -> new Thread(() -> manageDatamartMessage(m)).start());
		connector.attachListener("service.ness.datamarts", null, (m, c) -> new Thread(() -> manageDatamartMessage(m)).start());
	}

	private void addDatamartEventSubscribers(String sourceSelector, java.util.function.Predicate<Instant> predicate) {
		this.datamartConsumers.clear();
		java.util.function.BiConsumer subscriber;
		subscriber = (UniverseTagAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseTagAssertionConsumer) subscriber, connector.clientId() + "_master_TagAssertion", predicate, sourceSelector);
		subscriber = (UniversePlaceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePlaceAssertionConsumer) subscriber, connector.clientId() + "_master_PlaceAssertion", predicate, sourceSelector);
		subscriber = (UniverseIncidentRuleAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseIncidentRuleAssertionConsumer) subscriber, connector.clientId() + "_master_IncidentRuleAssertion", predicate, sourceSelector);
		subscriber = (UniversePartAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePartAssertionConsumer) subscriber, connector.clientId() + "_master_PartAssertion", predicate, sourceSelector);
		subscriber = (UniverseComputerAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseComputerAssertionConsumer) subscriber, connector.clientId() + "_master_ComputerAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplicationAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplicationAssertionConsumer) subscriber, connector.clientId() + "_master_ApplicationAssertion", predicate, sourceSelector);
		subscriber = (UniverseQueryAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseQueryAssertionConsumer) subscriber, connector.clientId() + "_master_QueryAssertion", predicate, sourceSelector);
		subscriber = (UniverseProcessAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseProcessAssertionConsumer) subscriber, connector.clientId() + "_master_ProcessAssertion", predicate, sourceSelector);
		subscriber = (UniverseSoftwareAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseSoftwareAssertionConsumer) subscriber, connector.clientId() + "_master_SoftwareAssertion", predicate, sourceSelector);
		subscriber = (UniverseObserverAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseObserverAssertionConsumer) subscriber, connector.clientId() + "_master_ObserverAssertion", predicate, sourceSelector);
		subscriber = (UniverseHardwareAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseHardwareAssertionConsumer) subscriber, connector.clientId() + "_master_HardwareAssertion", predicate, sourceSelector);
		subscriber = (UniverseAreaAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseAreaAssertionConsumer) subscriber, connector.clientId() + "_master_AreaAssertion", predicate, sourceSelector);
		subscriber = (UniverseCountermeasureAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseCountermeasureAssertionConsumer) subscriber, connector.clientId() + "_master_CountermeasureAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplianceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplianceAssertionConsumer) subscriber, connector.clientId() + "_master_ApplianceAssertion", predicate, sourceSelector);
		subscriber = (UniverseApplicationJavaAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseApplicationJavaAssertionConsumer) subscriber, connector.clientId() + "_master_ApplicationJavaAssertion", predicate, sourceSelector);
		subscriber = (UniverseModelAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseModelAssertionConsumer) subscriber, connector.clientId() + "_master_ModelAssertion", predicate, sourceSelector);
		subscriber = (UniversePersonAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniversePersonAssertionConsumer) subscriber, connector.clientId() + "_master_PersonAssertion", predicate, sourceSelector);
		subscriber = (UniverseAssetAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseAssetAssertionConsumer) subscriber, connector.clientId() + "_master_AssetAssertion", predicate, sourceSelector);
		subscriber = (UniverseOrderTypeAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseOrderTypeAssertionConsumer) subscriber, connector.clientId() + "_master_OrderTypeAssertion", predicate, sourceSelector);
		subscriber = (UniverseServiceAssertionConsumer) (event, topic) -> datamart.mount(event);
		datamartConsumers.add(subscriber);
		subscribe((UniverseServiceAssertionConsumer) subscriber, connector.clientId() + "_master_ServiceAssertion", predicate, sourceSelector);
	}

	private final Object monitor = new Object();

	private synchronized void manageDatamartMessage(String message) {
		synchronized(monitor) {
			JsonObject jsonObject = Json.fromJson(message, JsonObject.class);
			String operation = jsonObject.getAsJsonPrimitive("operation").getAsString();
			if (operation.equals("reload")) {
				this.datamartConsumers.forEach(c -> consumers.get(c).forEach(connector::detachListeners));
				datamart.init(this.sourceSelector);
				addDatamartEventSubscribers(this.sourceSelector, ts -> ts.isAfter(datamart.ts()));
			} else if (operation.equals("refresh"))
				jsonObject.get("changes").getAsJsonArray().asList().stream()
					.map(e -> e.getAsString())
					.forEach(datamart::handleDatahubNotification);
		}
	}

	private String channelOf(String type) {
		return switch(type) {
			case "Status" -> "monitoring.Status";
			case "AreaAssertion" -> "universe.AreaAssertion";
			case "PartAssertion" -> "universe.PartAssertion";
			case "AssetAssertion" -> "universe.AssetAssertion";
			case "HardwareAssertion" -> "universe.HardwareAssertion";
			case "ApplianceAssertion" -> "universe.ApplianceAssertion";
			case "ComputerAssertion" -> "universe.ComputerAssertion";
			case "SoftwareAssertion" -> "universe.SoftwareAssertion";
			case "ObserverAssertion" -> "universe.ObserverAssertion";
			case "ServiceAssertion" -> "universe.ServiceAssertion";
			case "ProcessAssertion" -> "universe.ProcessAssertion";
			case "PersonAssertion" -> "universe.PersonAssertion";
			case "ApplicationAssertion" -> "universe.ApplicationAssertion";
			case "ApplicationJavaAssertion" -> "universe.ApplicationJavaAssertion";
			case "Computer" -> "monitoring.Computer";
			case "Application" -> "monitoring.Application";
			case "RdbmsStatement" -> "monitoring.RdbmsStatement";
			default -> null;
		};
	}

	public class BatchSession {
		private final java.io.File temporalStage;
		private final io.intino.alexandria.ingestion.SessionHandler sessionHandler;
		private final io.intino.alexandria.ingestion.EventSession session;
		private final Scale scale;

		public BatchSession(java.io.File temporalStage) {
			this(temporalStage, new Config());
		}

		public BatchSession(java.io.File temporalStage, Config config) {
			this.temporalStage = temporalStage;
			this.scale = config.scale;
			this.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);
			this.session = sessionHandler.createEventSession(config.eventsBufferSize);
		}

		public void feed(Event event) throws java.io.IOException {
			session.put(tankOf(event), event.ss(), Timetag.of(event.ts(), this.scale), event.format(), event);
		}

		public void feed(Event event, Scale scale) throws java.io.IOException {
			session.put(tankOf(event), event.ss(), Timetag.of(event.ts(), scale), event.format(), event);
		}

		public void flush() {
			session.flush();
		}

		public void push(File dataHubStage) {
			session.close();
			sessionHandler.pushTo(dataHubStage);
			//connector.sendEvent("service.ness.push", new Event(new io.intino.alexandria.message.Message("Push").set("stage", temporalStage.getName())));
		}

		public void push(String host, String user, String dataHubStageAbsolutePath) {
			session.close();
			try {
				List<File> files = allFilesIn(temporalStage.toPath(), path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());
				upload(files, host, user, dataHubStageAbsolutePath);
				temporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + ".treated"));
			} catch(Exception e) {
				Logger.error(e);
			}
		}

		private static Stream<File> allFilesIn(java.nio.file.Path path, java.util.function.Predicate<File> filter) throws Exception {
			Stream.Builder<File> streamBuilder = Stream.builder();
			try (Stream<java.nio.file.Path> paths = java.nio.file.Files.walk(path)) {
				paths.filter(p -> java.nio.file.Files.isRegularFile(p) && filter.test(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));
			}
			return streamBuilder.build();
		}

		public synchronized void seal() {
			connector.requestResponse("service.ness.seal", request("Seal", Map.of("stage", temporalStage.getName())));
		}

		private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
			try {
				String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
				Logger.info("Uploading sessions to " + connectionChain + "...");
				for (File s : sessions) {
					Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain)
							.inheritIO()
							.start();
					process.waitFor(1, java.util.concurrent.TimeUnit.HOURS);
				}
				Logger.info("sessions uploaded");
			} catch (java.io.IOException | InterruptedException ignored) {
			}

		}

		private String tankOf(Event event) {
			if (event instanceof io.intino.cosmos.datahub.messages.monitoring.Status) return "monitoring.Status";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.AreaAssertion) return "universe.AreaAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.PartAssertion) return "universe.PartAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.AssetAssertion) return "universe.AssetAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.HardwareAssertion) return "universe.HardwareAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ApplianceAssertion) return "universe.ApplianceAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ComputerAssertion) return "universe.ComputerAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.SoftwareAssertion) return "universe.SoftwareAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ObserverAssertion) return "universe.ObserverAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ServiceAssertion) return "universe.ServiceAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ProcessAssertion) return "universe.ProcessAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.PersonAssertion) return "universe.PersonAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ApplicationAssertion) return "universe.ApplicationAssertion";
			if (event instanceof io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion) return "universe.ApplicationJavaAssertion";
			if (event instanceof io.intino.cosmos.datahub.measurements.monitoring.Computer) return "monitoring.Computer";
			if (event instanceof io.intino.cosmos.datahub.measurements.monitoring.Application) return "monitoring.Application";
			if (event instanceof io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement) return "monitoring.RdbmsStatement";
			return event.type();
		}
	}

	public static class Config {
		private int eventsBufferSize = 1_000_000;
		private int setsBufferSize = 1_000_000;
		private Scale scale = Scale.Day;

		public Config scale(Scale scale) {
			this.scale = scale;
			return this;
		}

		public Config eventsBufferSize(int eventsBufferSize) {
			this.eventsBufferSize = eventsBufferSize;
			return this;
		}

		public Config setsBufferSize(int setsBufferSize) {
			this.setsBufferSize = setsBufferSize;
			return this;
		}
	}

	public interface UniverseQueryAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.QueryAssertion, String> {
	}

	public interface UniverseSoftwareAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.SoftwareAssertion, String> {
	}

	public interface UniverseModelAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ModelAssertion, String> {
	}

	public interface UniverseAssetAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.AssetAssertion, String> {
	}

	public interface UniverseComputerAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ComputerAssertion, String> {
	}

	public interface MonitoringStatusConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.Status, String> {
	}

	public interface UniverseHardwareAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.HardwareAssertion, String> {
	}

	public interface UniverseApplicationJavaAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion, String> {
	}

	public interface UniverseCountermeasureAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion, String> {
	}

	public interface UniverseApplianceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplianceAssertion, String> {
	}

	public interface UniverseProcessAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ProcessAssertion, String> {
	}

	public interface UniversePartAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PartAssertion, String> {
	}

	public interface UniverseApplicationAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ApplicationAssertion, String> {
	}

	public interface UniverseServiceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ServiceAssertion, String> {
	}

	public interface UniverseIncidentRuleAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion, String> {
	}

	public interface UniverseAreaAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.AreaAssertion, String> {
	}

	public interface UniverseOrderTypeAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion, String> {
	}

	public interface MonitoringIncidentFinishedConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.IncidentFinished, String> {
	}

	public interface UniverseTagAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.TagAssertion, String> {
	}

	public interface UniverseObserverAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.ObserverAssertion, String> {
	}

	public interface MonitoringIncidentConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.monitoring.Incident, String> {
	}

	public interface UniversePersonAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PersonAssertion, String> {
	}

	public interface UniversePlaceAssertionConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.messages.universe.PlaceAssertion, String> {
	}
	public interface MonitoringApplicationConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Application, String> {
	}

	public interface MonitoringSwitchConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Switch, String> {
	}

	public interface AnalysisAnalysisConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.analysis.Analysis, String> {
	}

	public interface MonitoringWirelessConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Wireless, String> {
	}

	public interface MonitoringComputerConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Computer, String> {
	}

	public interface MonitoringCameraConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.Camera, String> {
	}

	public interface MonitoringRdbmsStatementConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement, String> {
	}

	public interface MonitoringCellularGatewayConsumer extends java.util.function.BiConsumer<io.intino.cosmos.datahub.measurements.monitoring.CellularGateway, String> {
	}



	public static class DatamartsRetryConfig {
		public final long initialTimeoutAmount;
		public final java.util.concurrent.TimeUnit timeoutUnit;
		public final float timeoutMultiplier;
		public final int maxAttempts;

		public DatamartsRetryConfig() {
			this(1, java.util.concurrent.TimeUnit.MINUTES, 2.0f, 5);
		}

		public DatamartsRetryConfig(long initialTimeoutAmount, java.util.concurrent.TimeUnit timeoutUnit, float timeoutMultiplier, int maxAttempts) {
			this.initialTimeoutAmount = initialTimeoutAmount;
			this.timeoutUnit = timeoutUnit;
			this.timeoutMultiplier = timeoutMultiplier;
			this.maxAttempts = maxAttempts;
		}
	}
}