/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.ARPACK;
import smile.math.matrix.Matrix;

public class MDS {
    private static final Logger logger = LoggerFactory.getLogger(MDS.class);
    public final double[] scores;
    public final double[][] coordinates;
    public final double[] proportion;

    public MDS(double[] scores, double[] proportion, double[][] coordinates) {
        this.scores = scores;
        this.proportion = proportion;
        this.coordinates = coordinates;
    }

    public static MDS of(double[][] proximity) {
        return MDS.of(proximity, new Properties());
    }

    public static MDS of(double[][] proximity, int k) {
        return MDS.of(proximity, k, false);
    }

    public static MDS of(double[][] proximity, Properties params) {
        int k = Integer.parseInt(params.getProperty("smile.mds.k", "2"));
        boolean positive = Boolean.parseBoolean(params.getProperty("smile.mds.positive", "false"));
        return MDS.of(proximity, k, positive);
    }

    public static MDS of(double[][] proximity, int k, boolean positive) {
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (k < 1 || k >= n) {
            throw new IllegalArgumentException("Invalid k = " + k);
        }
        Matrix A = new Matrix(n, n);
        Matrix B = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double x = -0.5 * MathEx.pow2(proximity[i][j]);
                A.set(i, j, x);
                A.set(j, i, x);
            }
        }
        double[] mean = A.rowMeans();
        double mu = MathEx.mean(mean);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = A.get(i, j) - mean[i] - mean[j] + mu;
                B.set(i, j, x);
                B.set(j, i, x);
            }
        }
        if (positive) {
            int i;
            Matrix Z = new Matrix(2 * n, 2 * n);
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Z.set(i, n + j, 2.0 * B.get(i, j));
                }
            }
            for (i = 0; i < n; ++i) {
                Z.set(n + i, i, -1.0);
            }
            mean = MathEx.rowMeans(proximity);
            mu = MathEx.mean(mean);
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Z.set(n + i, n + j, 2.0 * (proximity[i][j] - mean[i] - mean[j] + mu));
                }
            }
            double[] eigvalues = Z.eigen((boolean)false, (boolean)false, (boolean)true).wr;
            double c = MathEx.max(eigvalues);
            for (int i2 = 0; i2 < n; ++i2) {
                B.set(i2, i2, 0.0);
                for (int j = 0; j < i2; ++j) {
                    double x = -0.5 * MathEx.pow2(proximity[i2][j] + c);
                    B.set(i2, j, x);
                    B.set(j, i2, x);
                }
            }
        }
        B.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev(B, ARPACK.SymmOption.LA, k);
        if (eigen.wr.length < k) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)k, (Object)eigen.wr.length);
            k = eigen.wr.length;
        }
        double[][] coordinates = new double[n][k];
        for (int j = 0; j < k; ++j) {
            if (eigen.wr[j] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", k));
            }
            double scale = Math.sqrt(eigen.wr[j]);
            for (int i = 0; i < n; ++i) {
                coordinates[i][j] = eigen.Vr.get(i, j) * scale;
            }
        }
        double[] eigenvalues = eigen.wr;
        double[] proportion = (double[])eigenvalues.clone();
        MathEx.unitize1(proportion);
        return new MDS(eigenvalues, proportion, coordinates);
    }
}

