/*
 * Decompiled with CFR 0.152.
 */
package smile.glm.model;

import java.util.Arrays;
import java.util.stream.IntStream;
import smile.glm.model.Model;
import smile.math.MathEx;

public interface Poisson {
    public static Model log() {
        return new Model(){

            public String toString() {
                return "Poisson(log)";
            }

            @Override
            public double link(double mu) {
                return Math.log(mu);
            }

            @Override
            public double invlink(double eta) {
                return Math.exp(eta);
            }

            @Override
            public double dlink(double mu) {
                return 1.0 / mu;
            }

            @Override
            public double variance(double mu) {
                return mu;
            }

            @Override
            public double mustart(double y) {
                if (y < 0.0) {
                    throw new IllegalArgumentException("Invalid argument (expected non-negative): " + y);
                }
                return y == 0.0 ? 0.5 : y;
            }

            @Override
            public double deviance(double[] y, double[] mu, double[] residuals) {
                return IntStream.range(0, y.length).mapToDouble(i -> {
                    double d = 2.0 * y[i] * Math.log(y[i] / mu[i]);
                    residuals[i] = Math.sqrt(d) * Math.signum(y[i] - mu[i]);
                    return d;
                }).sum();
            }

            @Override
            public double nullDeviance(double[] y, double mu) {
                return Arrays.stream(y).map(yi -> 2.0 * yi * Math.log(yi / mu)).sum();
            }

            @Override
            public double logLikelihood(double[] y, double[] mu) {
                return IntStream.range(0, y.length).mapToDouble(i -> -mu[i] + y[i] * Math.log(mu[i]) - MathEx.lfactorial((int)y[i])).sum();
            }
        };
    }
}

