/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.util.Arrays;
import java.util.HashMap;
import smile.data.DataFrame;
import smile.data.transform.InvertibleColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.Function;
import smile.math.MathEx;

public class MaxAbsScaler {
    public static InvertibleColumnTransform fit(DataFrame data, String ... columns) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        if (columns.length == 0) {
            columns = (String[])Arrays.stream(schema.fields()).filter(StructField::isNumeric).map(field -> field.name).toArray(String[]::new);
        }
        HashMap<String, Function> transforms = new HashMap<String, Function>();
        HashMap<String, Function> inverses = new HashMap<String, Function>();
        for (String column : columns) {
            final StructField field2 = schema.field(column);
            if (!field2.isNumeric()) {
                throw new IllegalArgumentException(String.format("%s is not numeric", field2.name));
            }
            double[] vector = data.column(column).toDoubleArray();
            double max = 0.0;
            for (double xi : vector) {
                max = Math.max(max, Math.abs(xi));
            }
            final double scale = MathEx.isZero(max) ? 1.0 : max;
            Function transform = new Function(){

                @Override
                public double f(double x) {
                    return x / scale;
                }

                public String toString() {
                    return String.format("%s / %.4f", field2.name, scale);
                }
            };
            Function inverse = x -> x * scale;
            transforms.put(field2.name, transform);
            inverses.put(field2.name, inverse);
        }
        return new InvertibleColumnTransform("MaxAbsScaler", transforms, inverses);
    }
}

