/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.type.TesparSymbol;

public class TesparDzCoding
implements GenericTransformer<double[], int[]> {
    private static final long serialVersionUID = 7734158131264856074L;

    @Override
    public int[] transform(double[] values) {
        TesparSymbol[] symbols = this.getTesparSymbols(values);
        return this.getHistogram(symbols);
    }

    private int[] getHistogram(TesparSymbol[] symbols) {
        int[] result = new int[27];
        for (int i = 1; i < symbols.length; ++i) {
            TesparSymbol currentSymbol = symbols[i];
            TesparSymbol prevSymbol = symbols[i - 1];
            int code = 14;
            if (currentSymbol.getAmplitude() > prevSymbol.getAmplitude()) {
                --code;
            } else if (currentSymbol.getAmplitude() < prevSymbol.getAmplitude()) {
                ++code;
            }
            if (currentSymbol.getShape() > prevSymbol.getShape()) {
                code -= 3;
            } else if (currentSymbol.getShape() < prevSymbol.getShape()) {
                code += 3;
            }
            if (currentSymbol.getDuration() > prevSymbol.getDuration()) {
                code -= 9;
            } else if (currentSymbol.getDuration() < prevSymbol.getDuration()) {
                code += 9;
            }
            int n = code - 1;
            result[n] = result[n] + 1;
        }
        return result;
    }

    private TesparSymbol[] getTesparSymbols(double[] values) {
        int n = 0;
        for (int i = 1; i < values.length; ++i) {
            if (values[i - 1] == values[i] || !(values[i - 1] <= 0.0 && values[i] >= 0.0) && (!(values[i - 1] >= 0.0) || !(values[i] <= 0.0))) continue;
            ++n;
        }
        TesparSymbol[] result = new TesparSymbol[n];
        double amplitude = values[0];
        int start = 0;
        int shape = 0;
        n = 0;
        for (int i = 1; i < values.length; ++i) {
            if (values[i - 1] != values[i] && (values[i - 1] <= 0.0 && values[i] >= 0.0 || values[i - 1] >= 0.0 && values[i] <= 0.0)) {
                result[n] = new TesparSymbol(i - start, shape, FastMath.abs(amplitude));
                start = i;
                shape = 0;
                amplitude = values[i];
                ++n;
                continue;
            }
            if (i < values.length - 1 && this.isShape(values[i - 1], values[i], values[i + 1])) {
                ++shape;
            }
            if (values[i] > 0.0 && values[i] > amplitude) {
                amplitude = values[i];
            }
            if (!(values[i] < 0.0) || !(values[i] < amplitude)) continue;
            amplitude = values[i];
        }
        return result;
    }

    private boolean isShape(double a, double b, double c) {
        if (a > 0.0 && b > 0.0 && c > 0.0 && a > b && b < c) {
            return true;
        }
        return a < 0.0 && b < 0.0 && c < 0.0 && a < b && b > c;
    }
}

