/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class PasswordIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private SecretKey keyEncryptionKey;

    PasswordIntRecipientInfoGenerator() {
    }

    void setKeyDerivationAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.keyDerivationAlgorithm = algorithmIdentifier;
    }

    void setKeyEncryptionKey(SecretKey secretKey) {
        this.keyEncryptionKey = secretKey;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        CMSEnvelopedHelper cMSEnvelopedHelper = CMSEnvelopedHelper.INSTANCE;
        String string = cMSEnvelopedHelper.getRFC3211WrapperName(this.keyEncryptionKey.getAlgorithm());
        Cipher cipher = cMSEnvelopedHelper.createSymmetricCipher(string, provider);
        cipher.init(3, (Key)this.keyEncryptionKey, secureRandom);
        byte[] byArray = cipher.wrap(secretKey);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERObjectIdentifier(this.keyEncryptionKey.getAlgorithm()));
        aSN1EncodableVector.add(new DEROctetString(cipher.getIV()));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, algorithmIdentifier, dEROctetString));
    }
}

