/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.blocks;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class TimeModel
implements TimelineStore.TimeModel {
    public static final int SIZE = 14;
    private final Instant instant;
    private final Period period;

    public TimeModel(Instant instant, Period period) {
        this.instant = instant;
        this.period = period;
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    @Override
    public Period period() {
        return this.period;
    }

    @Override
    public ChronoUnit unit() {
        return this.period.unit;
    }

    @Override
    public long duration() {
        return this.period.duration();
    }

    @Override
    public Instant next(Instant instant) {
        return this.period.next(instant);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineStore.TimeModel timeModel = (TimelineStore.TimeModel)o;
        return Objects.equals(this.instant, timeModel.instant()) && Objects.equals(this.period, timeModel.period());
    }

    public int hashCode() {
        return Objects.hash(this.instant, this.period);
    }

    public String toString() {
        return "from " + this.instant + " each " + this.period;
    }

    public static ByteBuffer serialize(TimelineStore.TimeModel timeModel) {
        return TimeModel.serialize(timeModel, ByteBuffer.allocate(14)).clear();
    }

    public static ByteBuffer serialize(TimelineStore.TimeModel timeModel, ByteBuffer buffer) {
        buffer.putShort((short)26208);
        buffer.putLong(timeModel.instant().toEpochMilli());
        buffer.putShort((short)timeModel.period().amount);
        buffer.putShort((short)timeModel.period().unit.ordinal());
        return buffer;
    }

    public static TimelineStore.TimeModel deserialize(ReadableByteChannel channel, boolean readMark) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(readMark ? 14 : 12);
        channel.read(buffer);
        buffer.position(readMark ? 2 : 0);
        Instant instant = Instant.ofEpochMilli(buffer.getLong());
        short periodAmount = buffer.getShort();
        short periodUnit = buffer.getShort();
        return new TimeModel(instant, new Period(periodAmount, ChronoUnit.values()[periodUnit]));
    }
}

