/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import io.intino.sumus.chronos.timelines.stores.FileTimelineStore;
import io.intino.sumus.chronos.timelines.writers.FileTimelineWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;

public interface TimelineStore {
    public static TimelineStore of(File file) throws IOException {
        return new FileTimelineStore(file);
    }

    public static Builder createIfNotExists(String sensor, File file) {
        return new Builder(sensor, file);
    }

    default public TimelineWriter writer() throws IOException {
        if (this instanceof FileTimelineStore) {
            return new FileTimelineWriter(this.sensor(), ((FileTimelineStore)this).file(), true);
        }
        throw new UnsupportedOperationException("No writers for " + this.getClass().getSimpleName());
    }

    public Timeline timeline() throws IOException;

    public Header header();

    public SensorModel sensorModel();

    public TimeModel timeModel();

    default public String id() {
        return this.sensor();
    }

    default public String sensor() {
        return this.header().sensor();
    }

    default public Instant first() {
        return this.header().first();
    }

    default public Instant last() {
        return this.header().last();
    }

    default public Instant next() {
        return this.header().next();
    }

    default public Period period() {
        if (this.timeModel() == null) {
            throw new IllegalStateException("TimeModel is not set");
        }
        return this.timeModel().period();
    }

    public static class Builder {
        private final String sensor;
        private final File file;
        private TimeModel timeModel;
        private SensorModel sensorModel;

        public Builder(String sensor, File file) {
            this.sensor = sensor;
            this.file = file;
        }

        public TimelineStore build() throws IOException {
            if (this.file.exists()) {
                return TimelineStore.of(this.file);
            }
            this.file.getParentFile().mkdirs();
            try (FileTimelineWriter writer = new FileTimelineWriter(this.sensor, this.file, false);){
                if (this.sensorModel != null) {
                    writer.sensorModel(this.sensorModel);
                }
                if (this.timeModel != null) {
                    writer.timeModel(this.timeModel);
                }
            }
            return TimelineStore.of(this.file);
        }

        public Builder withTimeModel(Instant start, Period period) {
            this.timeModel = new io.intino.sumus.chronos.timelines.blocks.TimeModel(start, period);
            return this;
        }

        public Builder withSensorModel(String ... magnitudes) {
            this.sensorModel = new io.intino.sumus.chronos.timelines.blocks.SensorModel(magnitudes);
            return this;
        }

        public Builder withSensorModel(Magnitude ... magnitudes) {
            this.sensorModel = new io.intino.sumus.chronos.timelines.blocks.SensorModel(magnitudes);
            return this;
        }
    }

    public static interface Data
    extends Block,
    Iterable<Record> {
        public static final short MARK = 21845;

        @Override
        default public short mark() {
            return 21845;
        }

        public int numRecords();

        public int numMeasurementsPerRecord();

        public int recordByteSize();

        public ByteBuffer dataBuffer();

        public Record record(int var1);

        public static interface Record {
            public int index();

            public Instant instant();

            public double[] values();

            public double get(int var1);

            public int byteSize();

            public int numMeasurements();
        }
    }

    public static interface SensorModel
    extends Block,
    Iterable<Magnitude> {
        public static final short MARK = 26209;

        @Override
        default public short mark() {
            return 26209;
        }

        public Magnitude[] magnitudes();

        public Magnitude get(int var1);

        public Magnitude get(String var1);

        public int indexOf(Magnitude var1);

        public int indexOf(String var1);

        public int size();

        public boolean has(String var1);

        public boolean has(Magnitude var1);

        default public boolean contains(SensorModel other) {
            Magnitude[] otherMagnitudes;
            Magnitude[] myMagnitudes = this.magnitudes();
            if (myMagnitudes.length < (otherMagnitudes = other.magnitudes()).length) {
                return false;
            }
            for (int i = 0; i < otherMagnitudes.length; ++i) {
                if (myMagnitudes[i].equals((Object)otherMagnitudes[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        default public Iterator<Magnitude> iterator() {
            return new Iterator<Magnitude>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < this.size();
                }

                @Override
                public Magnitude next() {
                    return this.get(this.i++);
                }
            };
        }
    }

    public static interface TimeModel
    extends Block {
        public static final short MARK = 26208;

        @Override
        default public short mark() {
            return 26208;
        }

        public Instant instant();

        public Period period();

        public ChronoUnit unit();

        public long duration();

        public Instant next(Instant var1);
    }

    public static interface Header
    extends Block {
        public static final short MARK = 20485;

        @Override
        default public short mark() {
            return 20485;
        }

        public String sensor();

        public long sensorModelPosition();

        public long timeModelPosition();

        public long recordCount();

        public Instant first();

        public Instant last();

        public Instant next();
    }

    public static interface Block {
        public short mark();
    }
}

