/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.report;

import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.report.Issue;
import io.intino.cosmos.bigbang.box.report.IssueReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TxtIssueReportDocumentBuilder {
    private final IssueReport issueReport;

    public TxtIssueReportDocumentBuilder(IssueReport issueReport) {
        this.issueReport = issueReport;
    }

    public void build(File file) {
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.title(writer);
            for (Map.Entry<String, List<Issue>> entry : this.sortByNumErrors(this.issueReport.getAll().entrySet())) {
                String path = entry.getKey();
                List<Issue> issues = entry.getValue();
                if (issues.isEmpty()) continue;
                issues.sort(Comparator.naturalOrder());
                writer.newLine();
                writer.newLine();
                this.println(writer, path.equals("Other") ? "==== General issues (" + issues.size() + ") ====\n" : "==== '" + path + "' (Issues: " + issues.size() + ") ====\n");
                this.printAll(writer, issues.stream().filter(i -> i.level() == Issue.Level.Error));
                this.printAll(writer, issues.stream().filter(i -> i.level() == Issue.Level.Warning));
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void title(BufferedWriter writer) {
        this.println(writer, "MASTER ISSUES REPORT\n");
        this.println(writer, "Date: " + String.valueOf(LocalDateTime.now()));
        this.println(writer, "Errors: " + this.issueReport.errorCount());
        this.println(writer, "Warnings: " + this.issueReport.warningCount());
        this.println(writer, "Files with problems: " + this.issueReport.getAll().size());
    }

    private Iterable<? extends Map.Entry<String, List<Issue>>> sortByNumErrors(Set<Map.Entry<String, List<Issue>>> entrySet) {
        return entrySet.stream().sorted((e1, e2) -> -Integer.compare(this.numErrors((List)e1.getValue()), this.numErrors((List)e2.getValue()))).collect(Collectors.toList());
    }

    private int numErrors(List<Issue> issueList) {
        return (int)issueList.stream().filter(issue -> issue.level().equals((Object)Issue.Level.Error)).count();
    }

    private void printAll(BufferedWriter writer, Stream<Issue> issues) {
        issues.forEach(issue -> this.println(writer, issue.toString() + "\n"));
    }

    private void println(BufferedWriter writer, String msg) {
        try {
            writer.write(msg);
            writer.newLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

