/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.report;

import java.io.File;
import java.util.Objects;

public class Issue
implements Comparable<Issue> {
    private final String type;
    private final Level level;
    private final String message;
    private File sourceFile;
    private int line;

    public static Issue error(String type, String message) {
        return new Issue(type, Level.Error, message);
    }

    public static Issue warning(String type, String message) {
        return new Issue(type, Level.Warning, message);
    }

    public static Issue create(Level level, String type, String message) {
        return new Issue(type, level, message);
    }

    public Issue(String type, Level level, String message) {
        this.type = Objects.requireNonNull(type);
        this.level = level;
        this.message = message;
    }

    public String type() {
        return this.type;
    }

    public Level level() {
        return this.level;
    }

    public String message() {
        return this.message;
    }

    public File sourceFile() {
        return this.sourceFile;
    }

    public Issue sourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
        return this;
    }

    public int sourceFileLine() {
        return this.line;
    }

    public Issue sourceFileLine(int line) {
        this.line = line;
        return this;
    }

    public Issue source(File file) {
        this.sourceFile = file;
        this.line = 0;
        return this;
    }

    public String levelMsg() {
        return "[" + this.level.name().toUpperCase() + "] [" + this.type + "] " + this.message;
    }

    public String toString() {
        return this.levelMsg() + (String)(this.sourceFile == null ? "" : "\n\t" + String.valueOf(this.sourceFile));
    }

    @Override
    public int compareTo(Issue o) {
        if (o == null) {
            return -1;
        }
        return this.level == o.level ? this.compareSources(o) : this.level.compareTo(o.level);
    }

    private int compareSources(Issue other) {
        if (this.sourceFile == null) {
            return 1;
        }
        if (other.sourceFile == null) {
            return -1;
        }
        return Integer.compare(this.line, other.line);
    }

    public String getSourceString() {
        return String.valueOf(this.sourceFile) + "(" + this.line + ")";
    }

    public static enum Level {
        Error,
        Warning;

    }

    public static class Type {
        public static final String SYNTAX_ERROR = "Syntax error";
        public static final String ASSERTION_WITHOUT_CLASS = "Class attribute not found";
        public static final String MISSING_ATTRIBUTE = "Missing attribute";
        public static final String MISSING_ASSERTION = "Missing assertion";
        public static final String DUPLICATED_ATTRIBUTE = "Duplicated attribute";
        public static final String INVALID_VALUE = "Invalid value";
        public static final String INVALID_ATTRIBUTE = "Invalid attribute";
        public static final String INVALID_REFERENCE = "Invalid reference";
        public static final String READ_FILE_ERROR = "Read File Error";
    }
}

