/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.jmx;

import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.actions.CheckAction;
import io.intino.cosmos.bigbang.box.actions.UpdateAction;
import io.intino.cosmos.bigbang.box.jmx.JmxMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Jmx
implements JmxMBean {
    private final BigBangBox box;

    @Override
    public List<String> help() {
        ArrayList<String> operations = new ArrayList<String>();
        operations.addAll(Arrays.asList("String check(String unit): Pull repository and check data in the specified branch", "String update(String unit): Pull repository, check and update the universe of the specified unit"));
        return operations;
    }

    public Jmx(BigBangBox box) {
        this.box = box;
    }

    @Override
    public String check(String unit) {
        try {
            CheckAction action = new CheckAction();
            action.box = this.box;
            action.unit = unit;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error(e);
            throw e;
        }
    }

    @Override
    public String update(String unit) {
        try {
            UpdateAction action = new UpdateAction();
            action.box = this.box;
            action.unit = unit;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error(e);
            throw e;
        }
    }
}

