/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.generators;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.FileTub;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.sealing.EventSessionSealer;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.generators.AssertionFactory;
import io.intino.cosmos.bigbang.box.generators.Formatters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.yaml.snakeyaml.Yaml;

public class UniverseAssertionGenerator {
    private final BigBangBox box;
    private final String domain;
    private final Yaml yaml;
    private final SessionHandler handler;
    private final File stage;
    private final Collection<File> profiles;

    public UniverseAssertionGenerator(BigBangBox box, String domain) throws IOException {
        this.box = box;
        this.domain = domain;
        this.yaml = new Yaml();
        this.stage = new File(box.archetype().tmp().root(), "big-bang-session");
        if (this.stage.exists()) {
            FileUtils.deleteDirectory(this.stage);
        }
        this.handler = new SessionHandler(this.stage);
        File profilesDir = new File(box.universeDir(), domain + ".domain" + File.separator + "profiles");
        this.profiles = profilesDir.exists() ? FileUtils.listFiles(profilesDir, new String[]{"yaml"}, false) : List.of();
    }

    public void execute() {
        EventSession eventSession = this.handler.createEventSession();
        FileUtils.listFiles(this.box.universeDir(), new String[]{"yaml"}, false).forEach(file -> this.processFile((File)file, eventSession));
        FileUtils.listFiles(new File(this.box.universeDir(), this.domain + ".domain"), new String[]{"yaml"}, false).forEach(f -> this.processFile((File)f, eventSession));
        eventSession.close();
        this.seal(FileUtils.listFiles(this.stage, new String[]{"session"}, false));
        Logger.info("Pushed assertions to datalake");
    }

    private void processFile(File f, EventSession eventSession) {
        try {
            Map objects = (Map)this.yaml.load(new FileReader(f));
            String proposedAssertionClass = Formatters.assertionClassOf(f);
            for (Map.Entry entry : objects.entrySet()) {
                Map properties = (Map)entry.getValue();
                String definedAssertionClass = Formatters.capitalize(Formatters.lastPart(properties.getOrDefault("class", proposedAssertionClass).toString()) + "Assertion");
                MessageEvent event = AssertionFactory.of(this.domain, definedAssertionClass).create((String)entry.getKey(), properties);
                if (event.type().equalsIgnoreCase("ModelAssertion")) {
                    this.attachProfiles(event.toMessage());
                }
                eventSession.put("universe." + event.type(), this.clean(event.ss()), Timetag.of(event.ts(), Scale.Day), Event.Format.Message, event);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void attachProfiles(Message message) {
        this.profiles.stream().filter(profile -> this.isSuitable(Formatters.nameWithoutExtension(profile), message)).forEach(profile -> message.add(this.profile(message, (File)profile)));
    }

    private Message profile(Message message, File profile) {
        Message profileMessage = new Message("Profile").set("id", message.get("id").asString());
        try {
            Map variables = (Map)this.yaml.load(new FileReader(profile));
            variables.forEach((k, v) -> {
                Message variable = new Message("Variable").set("name", (String)k);
                ((Map)v).forEach(variable::set);
                profileMessage.add(variable);
            });
            return profileMessage;
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
            return profileMessage;
        }
    }

    private boolean isSuitable(String profile, Message message) {
        String id = message.get("id").asString();
        if (profile.equalsIgnoreCase(id)) {
            return true;
        }
        String[] tokens = id.split("\\.");
        return IntStream.iterate(tokens.length - 1, i -> i >= 0, i -> i - 1).anyMatch(i -> profile.equalsIgnoreCase(tokens[i]));
    }

    protected void seal(Collection<File> sessions) {
        FileDatalake datalake = new FileDatalake(this.box.datalakeRoot());
        List<File> backups = UniverseAssertionGenerator.backup(sessions, datalake);
        try {
            new EventSessionSealer(datalake, this.stage, this.box.archetype().tmp().root(), this.box.archetype().tmp().root()).seal();
        }
        catch (Exception e) {
            Logger.error(e);
            UniverseAssertionGenerator.rollBack(backups);
        }
    }

    private static List<File> backup(Collection<File> sessions, FileDatalake datalake) {
        ArrayList<File> backups = new ArrayList<File>();
        sessions.forEach(session -> {
            Fingerprint fingerprint = Fingerprint.of(session);
            File tub = UniverseAssertionGenerator.tub(datalake, fingerprint);
            if (tub != null) {
                backups.add(UniverseAssertionGenerator.backup(tub));
            }
        });
        return backups;
    }

    private static File tub(FileDatalake datalake, Fingerprint fingerprint) {
        Datalake.Store<MessageEvent> store = datalake.messageStore();
        Datalake.Store.Tub<MessageEvent> tub = store.tank(fingerprint.tank()).source(fingerprint.source()).tub(fingerprint.timetag());
        return tub == null ? null : ((FileTub)((Object)tub)).file();
    }

    private static void rollBack(List<File> backups) {
        backups.forEach(backup -> {
            try {
                File tub = new File(backup.getAbsolutePath().replace(".bak", ".zim"));
                Files.move(backup.toPath(), tub.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException ex) {
                Logger.error(ex);
            }
        });
    }

    private String clean(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }

    private static File backup(File tub) {
        try {
            File backup = new File(tub.getAbsolutePath().replace(".zim", ".bak"));
            Files.move(tub.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            return backup;
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }
}

