/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.generators;

import java.io.File;

public class Formatters {
    public static String assertionClassOf(File file) {
        return Formatters.capitalize(Formatters.toSingular(Formatters.toCamel(file.getName().replace(".yaml", ""))));
    }

    public static String lastPart(String className) {
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
    }

    public static String nameWithoutExtension(File file) {
        return file.getName().replace(".yaml", "");
    }

    public static String toSingular(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        if (word.endsWith("es")) {
            if (word.endsWith("sses") || word.endsWith("shes") || word.endsWith("ches") || word.endsWith("xes")) {
                return word.substring(0, word.length() - 2);
            }
            return word.substring(0, word.length() - 1);
        }
        if (word.endsWith("s")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static String toCamel(String snakeCase) {
        if (snakeCase == null || snakeCase.isEmpty()) {
            return snakeCase;
        }
        StringBuilder camelCase = new StringBuilder();
        boolean nextUpper = false;
        for (char ch : snakeCase.toCharArray()) {
            if (ch == '-') {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                camelCase.append(Character.toUpperCase(ch));
                nextUpper = false;
                continue;
            }
            camelCase.append(Character.toLowerCase(ch));
        }
        return camelCase.toString();
    }

    public static String capitalize(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }
}

