/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.scheduling.PullAndPropagateChangesListener;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(AlexandriaScheduler scheduler, File home, BigBangBox box) {
        try {
            JobDetail job = JobBuilder.newJob(PullAndPropagateChangesListener.class).withIdentity("pullAndPropagateChanges").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Services#pullAndPropagateChanges").withSchedule(CronScheduleBuilder.cronSchedule("0 0/5 * 1/1 * ? *")).build(), TriggerBuilder.newTrigger().startAt(Date.from(Instant.now().plus(10000L, ChronoUnit.MILLIS))).build()), true);
            scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }
}

