/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class GitRepository {
    private final String branch;
    private final Git git;
    private static final CustomJschConfigSessionFactory sshFactory = new CustomJschConfigSessionFactory();
    private static final TransportConfigCallback configCallback;

    public GitRepository(File directory, String remoteUri, String branch) throws GitAPIException, URISyntaxException {
        this.branch = branch;
        this.git = directory.exists() ? GitRepository.init(directory, remoteUri, branch) : this.clone(directory, remoteUri, branch);
    }

    private Git clone(File directory, String remoteUri, String branch) throws GitAPIException {
        Logger.info("Cloning repository " + remoteUri + " : " + branch);
        try {
            return ((CloneCommand)Git.cloneRepository().setTransportConfigCallback(configCallback)).setDirectory(directory).setURI(remoteUri).setRemote("origin").setNoTags().setBranch(branch).call();
        }
        catch (GitAPIException e) {
            GitRepository.deleteDir(directory);
            throw e;
        }
    }

    private static Git init(File directory, String remoteUri, String branch) throws GitAPIException, URISyntaxException {
        if (remoteUri == null) {
            return null;
        }
        Git git = Git.init().setDirectory(directory).setInitialBranch(branch).call();
        git.remoteSetUrl().setRemoteName("origin").setRemoteUri(new URIish(remoteUri)).call();
        return git;
    }

    public PullResult checkoutAndPull() {
        this.checkout(this.branch);
        return this.pull();
    }

    public PullResult pull() {
        try {
            Logger.info("Pulling repository...");
            org.eclipse.jgit.api.PullResult result = this.git.pull().setRebase(true).setRemote("origin").call();
            if (result.isSuccessful() && result.getRebaseResult().getStatus().equals((Object)RebaseResult.Status.FAST_FORWARD)) {
                return PullResult.FAST_FORWARD;
            }
            Logger.info("Repository pulled successfully");
            return PullResult.UP_TO_DATE;
        }
        catch (GitAPIException e) {
            Logger.error(e);
            return PullResult.UP_TO_DATE;
        }
    }

    public GitRepository checkout(String branch) {
        try {
            ((FetchCommand)this.git.fetch().setTransportConfigCallback(configCallback)).call();
            Logger.info("Checking out to branch " + branch);
            Object call = this.git.branchList().call();
            this.git.checkout().setCreateBranch(call.stream().noneMatch(b -> b.getName().endsWith("/" + branch))).setName(branch).call();
            Logger.info("Repository checked out to " + branch + " successfully");
        }
        catch (GitAPIException e) {
            Logger.error(e);
        }
        return this;
    }

    private static void deleteDir(File directory) {
        try {
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException ex) {
            Logger.error(ex);
        }
    }

    static {
        SshSessionFactory.setInstance(sshFactory);
        configCallback = transport -> {
            if (transport instanceof SshTransport) {
                SshTransport t2 = (SshTransport)transport;
                t2.setSshSessionFactory(sshFactory);
            }
        };
    }

    public static enum PullResult {
        UP_TO_DATE,
        FAST_FORWARD;

    }

    public static class CustomJschConfigSessionFactory
    extends JschConfigSessionFactory {
        @Override
        protected void configure(OpenSshConfig.Host host, Session session) {
            session.setConfig("StrictHostKeyChecking", "no");
        }

        @Override
        protected JSch createDefaultJSch(FS fs) throws JSchException {
            JSch defaultJSch = super.createDefaultJSch(fs);
            defaultJSch.removeAllIdentity();
            File home = fs.userHome();
            try {
                defaultJSch.addIdentity(new File(home, ".ssh/id_rsa").getAbsolutePath());
                defaultJSch.setKnownHosts(new File(home, ".ssh/known_hosts").getAbsolutePath());
                File config = new File(home, ".ssh/config");
                if (config.exists()) {
                    defaultJSch.setConfigRepository(OpenSSHConfig.parseFile(config.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                Logger.error(e);
            }
            return defaultJSch;
        }
    }
}

