/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.jms.ConnectionConfig;
import io.intino.alexandria.jmx.JMXServer;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.ConnectorFactory;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.BigBangConfiguration;
import io.intino.cosmos.bigbang.box.JMXJmx;
import io.intino.cosmos.bigbang.box.Sentinels;
import io.intino.cosmos.datahub.BigBangTerminal;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected BigBangConfiguration configuration;
    protected JMXServer jmx;
    protected Connector connector;
    protected BigBangTerminal terminal;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new BigBangConfiguration(args));
    }

    public AbstractBox(BigBangConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
        this.connector = ConnectorFactory.createConnector(new ConnectionConfig(this.configuration().get("datahub_url"), this.configuration().get("datahub_user"), this.configuration().get("datahub_password"), this.configuration().get("datahub_clientId"), this.configuration().get("keystore_file") == null ? null : new File(this.configuration().get("keystore_file")), this.configuration().get("truststore_file") == null ? null : new File(this.configuration().get("truststore_file")), this.configuration().get("keystore_password"), this.configuration().get("truststore_password")), this.configuration().get("datahub_outbox_directory") == null ? null : new File(this.configuration().get("datahub_outbox_directory")));
        this.terminal = new BigBangTerminal(this.connector);
    }

    @Override
    public BigBangConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
        if (this.connector instanceof JmsConnector) {
            ((JmsConnector)this.connector).stop();
        }
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    public BigBangTerminal terminal() {
        return this.terminal;
    }

    protected Connector datahubConnector() {
        return this.connector;
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    protected abstract String datamartsSourceSelector();

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
        this.jmx = new JMXJmx().init((BigBangBox)this);
        io.intino.alexandria.logger.Logger.info("Jmx service jmx: started!");
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    protected void initConnector() {
        if (!(this.connector instanceof JmsConnector) || ((JmsConnector)this.connector).connection() != null) {
            return;
        }
        JmsConnector connector = (JmsConnector)this.connector;
        if (connector.connection() == null) {
            connector.start();
        }
        if (this.configuration().get("datahub_url") != null) {
            while (connector.connection() == null) {
                try {
                    Thread.sleep(30000L);
                    connector.start();
                }
                catch (InterruptedException e) {
                    io.intino.alexandria.logger.Logger.error(e);
                }
            }
        }
    }

    protected void initTerminal() {
        if (this.terminal != null) {
            Instant sealStamp = this.terminal.requestLastSeal();
            io.intino.alexandria.logger.Logger.info("Last seal on " + sealStamp.toString());
            Predicate<Instant> filter = i -> !i.isBefore(sealStamp);
            this.terminal.initDatamarts(this.datamartsSourceSelector());
        }
    }

    protected void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (BigBangBox)this);
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

