/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing.sorters;

import io.intino.alexandria.sealing.EventSorter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ResourceEventSorter
extends EventSorter {
    public ResourceEventSorter(File file, File tempFolder) throws IOException {
        super(file, File.createTempFile("event", ".zip", tempFolder));
    }

    @Override
    public void sort(File destination) throws IOException {
        ZipEntryList entryList = this.listZipEntriesOf(this.file);
        if (entryList.isEmpty() || entryList.isSorted()) {
            return;
        }
        this.sortZipEntries(entryList.entries, destination);
    }

    private void sortZipEntries(String[] entries, File destination) throws IOException {
        try {
            Arrays.sort(entries);
            this.writeTheSortedEntriesIntoTheTempZipFile(entries);
            Files.move(this.temp.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            this.temp.delete();
        }
    }

    private void writeTheSortedEntriesIntoTheTempZipFile(String[] entries) throws IOException {
        try (ZipOutputStream zipOut = ResourceEventSorter.openZipForWriting(this.temp);
             ZipFile zipIn = new ZipFile(this.file);){
            for (String entryName : entries) {
                ZipEntry entry = zipIn.getEntry(entryName);
                zipOut.putNextEntry(entry);
                try (InputStream entryData = zipIn.getInputStream(entry);){
                    entryData.transferTo(zipOut);
                }
            }
        }
    }

    private ZipEntryList listZipEntriesOf(File file) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            String[] prevName = new String[1];
            boolean[] sorted = new boolean[]{true};
            String[] entries = (String[])zip.stream().map(ZipEntry::getName).peek(entry -> this.saveSortingInfo((String)entry, prevName, sorted)).toArray(String[]::new);
            ZipEntryList zipEntryList = new ZipEntryList(entries, sorted[0]);
            return zipEntryList;
        }
    }

    private void saveSortingInfo(String entry, String[] prevName, boolean[] sorted) {
        if (!sorted[0]) {
            return;
        }
        if (prevName[0] != null) {
            sorted[0] = prevName[0].compareTo(entry) <= 0;
        }
        prevName[0] = entry;
    }

    private static ZipOutputStream openZipForWriting(File temp) throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
    }

    private static class ZipEntryList {
        private final String[] entries;
        private final boolean sorted;

        public ZipEntryList(String[] entries, boolean sorted) {
            this.entries = entries;
            this.sorted = sorted;
        }

        public boolean isEmpty() {
            return this.entries.length == 0;
        }

        public boolean isSorted() {
            return this.sorted;
        }
    }
}

