/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Base64;
import io.intino.alexandria.Json;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.ExceptionFactory;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;

public class RequestBuilder {
    private final URL url;
    private final HttpHost proxy;
    private final List<NameValuePair> queryParameters;
    private final Map<String, String> headerParameters;
    private final Map<String, String> entityParts;
    private UrlEncodedFormEntity urlEncodedFormEntity;
    private final List<Resource> resources;
    private int timeOutMillis;
    private Auth auth;
    private Method method;
    private String path;

    public RequestBuilder(URL url) {
        this(url, null);
    }

    public RequestBuilder(URL url, HttpHost proxy) {
        this.url = url;
        this.proxy = proxy;
        this.timeOutMillis = 120000;
        this.queryParameters = new ArrayList<NameValuePair>();
        this.headerParameters = new LinkedHashMap<String, String>();
        this.entityParts = new LinkedHashMap<String, String>();
        this.resources = new ArrayList<Resource>();
    }

    public RequestBuilder timeOut(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
        return this;
    }

    public RequestBuilder basicAuth(String user, String password) {
        this.auth = new Auth(Auth.Type.Basic, Base64.encode((user + ":" + password).getBytes()));
        return this;
    }

    public RequestBuilder bearerAuth(String token) {
        this.auth = new Auth(Auth.Type.Bearer, token);
        return this;
    }

    public RequestBuilder queryParameter(String name, Object value) {
        if (value != null) {
            this.queryParameters.add(new BasicNameValuePair(name, RequestAdapter.adapt(value)));
        }
        return this;
    }

    public RequestBuilder headerParameter(String name, Object value) {
        if (value != null) {
            this.headerParameters.put(name, RequestAdapter.adapt(value));
        }
        return this;
    }

    public RequestBuilder entityPart(String name, Object content) {
        if (content != null) {
            this.entityParts.put(name, RequestAdapter.adapt(content));
        }
        return this;
    }

    public RequestBuilder entityPart(Resource resource) {
        this.resources.add(resource);
        return this;
    }

    public RequestBuilder entityPart(List<Resource> resources) {
        this.resources.addAll(resources);
        return this;
    }

    public RequestBuilder entityPart(UrlEncodedFormEntity urlEncodedFormEntity) {
        if (urlEncodedFormEntity != null) {
            this.urlEncodedFormEntity = urlEncodedFormEntity;
        }
        return this;
    }

    public Request build(Method method, String path) {
        this.method = method;
        this.path = path;
        return this.build();
    }

    Request build() {
        return () -> {
            try {
                HttpRequestBase request = this.method(this.method.name());
                request.setURI(this.buildUrl());
                if (this.auth != null) {
                    request.setHeader("Authorization", String.valueOf((Object)this.auth.type()) + " " + this.auth.token);
                }
                this.headerParameters.forEach(request::setHeader);
                if (!(this.resources.isEmpty() && this.entityParts.isEmpty() || !(request instanceof HttpEntityEnclosingRequestBase))) {
                    ((HttpEntityEnclosingRequestBase)request).setEntity(this.buildEntity());
                } else if (this.urlEncodedFormEntity != null && request instanceof HttpEntityEnclosingRequestBase) {
                    ((HttpEntityEnclosingRequestBase)request).setEntity(this.urlEncodedFormEntity);
                }
                return this.parseResponse(this.client().execute(request));
            }
            catch (IOException | URISyntaxException e) {
                throw new InternalServerError(e.getMessage());
            }
        };
    }

    private URI buildUrl() throws URISyntaxException {
        return new URIBuilder(this.pathUrl(this.url, this.path)).setParameters(this.queryParameters).build();
    }

    private HttpEntity buildEntity() {
        if (this.resources.isEmpty() && this.entityParts.size() == 1) {
            return this.stringEntity(String.valueOf(this.entityParts.values().iterator().next()));
        }
        return this.multipartEntity();
    }

    private HttpEntity multipartEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA).setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8);
        this.resources.forEach(r -> builder.addPart(r.name(), new InputStreamBody(RequestBuilder.stream(r), r.type() != null ? ContentType.create(r.type()) : ContentType.APPLICATION_OCTET_STREAM, r.name())));
        this.entityParts.forEach((key, value) -> builder.addPart((String)key, new StringBody((String)value, ContentType.APPLICATION_JSON)));
        return builder.build();
    }

    private static InputStream stream(Resource r) {
        try {
            return r.stream();
        }
        catch (IOException e) {
            Logger.error(e);
            return InputStream.nullInputStream();
        }
    }

    private HttpEntity stringEntity(String body) {
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        entity.setContentEncoding(StandardCharsets.UTF_8.displayName());
        return entity;
    }

    private HttpClient client() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeOutMillis).setProxy(this.proxy).build();
        return HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
    }

    private HttpRequestBase method(String methodName) {
        if ("GET".equals(methodName)) {
            return new HttpGet();
        }
        if ("POST".equals(methodName)) {
            return new HttpPost();
        }
        if ("PATCH".equals(methodName)) {
            return new HttpPatch();
        }
        if ("PUT".equals(methodName)) {
            return new HttpPut();
        }
        return new HttpDelete();
    }

    private String pathUrl(URL url, String path) {
        String baseUrl = url.toString();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return path.isEmpty() ? baseUrl : baseUrl + (String)(path.startsWith("/") ? path : "/" + path);
    }

    private Response parseResponse(HttpResponse response) throws AlexandriaException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw this.exception(statusCode, this.bodyContent(response));
            }
            return new RestResponse(statusCode, response.getAllHeaders(), response.getEntity().getContent());
        }
        catch (IOException e) {
            return new RestResponse(response.getStatusLine().getStatusCode(), response.getAllHeaders(), null);
        }
    }

    private AlexandriaException exception(int statusCode, String bodyContent) {
        try {
            AlexandriaException e;
            AlexandriaException alexandriaException = e = bodyContent.startsWith("{") ? RequestBuilder.alexandriaException(bodyContent) : null;
            if (e != null) {
                return ExceptionFactory.from(statusCode, e.getMessage(), e.parameters());
            }
            return ExceptionFactory.from(statusCode, bodyContent, Map.of());
        }
        catch (JsonSyntaxException e) {
            Logger.warn(e.getMessage() + ": " + bodyContent);
            return ExceptionFactory.from(statusCode, bodyContent, Map.of());
        }
    }

    private static AlexandriaException alexandriaException(String bodyContent) {
        JsonObject jsonObject = Json.fromString(bodyContent, JsonObject.class);
        Type asMap = new TypeToken<Map<String, String>>(){}.getType();
        return new AlexandriaException(jsonObject.get("code").getAsString(), jsonObject.get("detailMessage").getAsString(), jsonObject.has("parameters") ? (Map)Json.fromJson((JsonElement)jsonObject.get("parameters").getAsJsonObject(), asMap) : null);
    }

    private String bodyContent(HttpResponse response) {
        try {
            InputStream content = response.getEntity().getContent();
            String value = new String(content.readAllBytes(), StandardCharsets.UTF_8);
            content.close();
            return value;
        }
        catch (IOException e) {
            return "";
        }
    }

    private static class Auth {
        private final Type type;
        private final String token;

        public Auth(Type type, String token) {
            this.type = type;
            this.token = token;
        }

        public String token() {
            return this.token;
        }

        public Type type() {
            return this.type;
        }

        public static enum Type {
            Basic,
            Bearer;

        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }

    public static interface Request {
        public Response execute() throws AlexandriaException;
    }

    public static class RestResponse
    implements Response {
        private final int code;
        private final InputStream content;
        private final Map<String, String> headers;

        public RestResponse(int code, Header[] headers, InputStream content) {
            this.code = code;
            this.headers = Arrays.stream(headers).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (v1, v2) -> v1));
            this.content = content;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        @Override
        public String contentType() {
            return this.headers.get("Content-Type");
        }

        @Override
        public String content() {
            try {
                String value = new String(this.content.readAllBytes(), StandardCharsets.UTF_8);
                this.content.close();
                return value;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public InputStream contentAsStream() {
            return this.content;
        }
    }
}

