/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.logger.Logger;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class JmsConsumer {
    protected Session session;
    protected Destination destination;
    protected List<Consumer<Message>> listeners;
    protected MessageConsumer consumer;

    JmsConsumer(Session session, Destination destination) {
        this.session = session;
        this.destination = destination;
        this.listeners = new ArrayList<Consumer<Message>>();
    }

    public void listen(Consumer<Message> listener) {
        try {
            this.listeners.add(listener);
            if (this.consumer != null) {
                this.consumer.setMessageListener(m -> this.listeners.forEach(l -> l.accept(m)));
            }
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public List<Consumer<Message>> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void removeListener(Consumer<Message> listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }
}

