/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.iteratorstream;

import io.intino.alexandria.resourcecleaner.DisposableResource;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ResourceIteratorStream<T>
implements Stream<T>,
Iterator<T>,
Iterable<T>,
AutoCloseable {
    protected final Iterator<T> iterator;
    protected final DisposableResource resource;

    public ResourceIteratorStream(Iterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator);
        this.resource = this.createAutoDisposableResource(iterator);
    }

    protected DisposableResource createAutoDisposableResource(Iterator<T> iterator) {
        return DisposableResource.whenDestroyed(this).thenClose(iterator);
    }

    protected Stream<T> asJavaStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        try {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        if (closeHandler != null) {
            this.resource.addCloseHandler(closeHandler);
        }
        return this;
    }

    @Override
    public void close() {
        this.resource.close();
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.asJavaStream().filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.asJavaStream().map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.asJavaStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.asJavaStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.asJavaStream().mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.asJavaStream().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.asJavaStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.asJavaStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.asJavaStream().flatMapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.asJavaStream().distinct();
    }

    @Override
    public Stream<T> sorted() {
        return this.asJavaStream().sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.asJavaStream().sorted(comparator);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.asJavaStream().peek(action);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.asJavaStream().limit(maxSize);
    }

    @Override
    public Stream<T> skip(long n) {
        return this.asJavaStream().skip(n);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.sorted().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.asJavaStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.asJavaStream().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.asJavaStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.asJavaStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.asJavaStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.asJavaStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.asJavaStream().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.asJavaStream().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.asJavaStream().max(comparator);
    }

    @Override
    public long count() {
        return this.asJavaStream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.asJavaStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.asJavaStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.asJavaStream().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.asJavaStream().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.asJavaStream().findAny();
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1300);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.asJavaStream().sequential();
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.asJavaStream().parallel();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.asJavaStream().unordered();
    }
}

