/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.event.EventWriter;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ResourceHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class ResourceEventWriter
implements EventWriter<ResourceEvent> {
    private final File file;

    public ResourceEventWriter(File file) {
        this.file = file;
    }

    @Override
    public void write(ResourceEvent event) throws IOException {
        URI uri = URI.create("jar:" + String.valueOf(this.file.toPath().toUri()));
        try (FileSystem fs = FileSystems.newFileSystem(uri, Map.of("create", "true"));
             InputStream data = event.resource().stream();){
            ResourceEventWriter.addData(fs, event.getREI(), data);
            ResourceEventWriter.addMetaData(fs, event.getREI(), ResourceHelper.serializeMetadata(event, this.file));
        }
    }

    private static void addData(FileSystem fs, ResourceEvent.REI rei, InputStream data) throws IOException {
        Files.write(fs.getPath(ResourceEventWriter.normalizePath(rei), new String[0]), data.readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    private static void addMetaData(FileSystem fs, ResourceEvent.REI rei, String metadata) throws IOException {
        String entryMetadataName = ResourceEventWriter.normalizePath(rei) + ".metadata";
        Files.writeString(fs.getPath(entryMetadataName, new String[0]), (CharSequence)metadata, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    private static String normalizePath(ResourceEvent.REI rei) {
        return rei.resourceId().replace("/", "$").replace("\\", "$");
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

