/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;

public class FS {
    public static Stream<File> directoriesIn(File directory) {
        return Arrays.stream(FS.filesIn(directory, File::isDirectory, Sort.Natural));
    }

    public static Stream<File> directoriesIn(File directory, Sort sort) {
        return Arrays.stream(FS.filesIn(directory, File::isDirectory, sort));
    }

    public static Stream<File> filesIn(File directory, FileFilter filter) {
        return Arrays.stream(FS.filesIn(directory, filter, Sort.Natural));
    }

    public static Stream<File> allFilesIn(File directory, FileFilter filter) throws IOException {
        return FS.allFilesIn(directory.toPath(), filter);
    }

    public static void copyInto(File destination, InputStream inputStream) throws IOException {
        Files.copy(inputStream, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void append(File destination, InputStream inputStream) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destination, true));){
            inputStream.transferTo(outputStream);
        }
    }

    private static Stream<File> allFilesIn(Path path, FileFilter filter) throws IOException {
        Stream.Builder streamBuilder = Stream.builder();
        try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
            paths.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && filter.accept(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));
        }
        return streamBuilder.build();
    }

    private static File[] filesIn(File root, FileFilter filter, Sort sort) {
        File[] files = root.listFiles(filter);
        files = files == null ? new File[]{} : files;
        Arrays.sort(files, sort.comparator);
        return files;
    }

    public static enum Sort {
        Natural(Comparator.comparing(File::getName)),
        Reversed(Comparator.comparing(File::getName).reversed());

        private final Comparator<File> comparator;

        private Sort(Comparator<File> comparator) {
            this.comparator = comparator;
        }
    }
}

