/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.MAC;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

abstract class HMAC
implements MAC {
    protected String name;
    protected int bsize;
    protected Digest digest;
    protected boolean etm;
    private HMac mac;
    private final byte[] tmp = new byte[4];

    HMAC() {
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (key.length > this.bsize) {
            byte[] tmp = new byte[this.bsize];
            System.arraycopy(key, 0, tmp, 0, this.bsize);
            key = tmp;
        }
        KeyParameter skey = new KeyParameter(key, 0, key.length);
        this.mac = new HMac(this.digest);
        this.mac.init(skey);
    }

    @Override
    public void update(int i) {
        this.tmp[0] = (byte)(i >>> 24);
        this.tmp[1] = (byte)(i >>> 16);
        this.tmp[2] = (byte)(i >>> 8);
        this.tmp[3] = (byte)i;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] foo, int s, int l) {
        this.mac.update(foo, s, l);
    }

    @Override
    public void doFinal(byte[] buf, int offset) {
        this.mac.doFinal(buf, offset);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isEtM() {
        return this.etm;
    }
}

