/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(JSch.class);

    @Override
    public boolean isEnabled(int level) {
        switch (level) {
            case 0: {
                return logger.isDebugEnabled();
            }
            case 1: {
                return logger.isInfoEnabled();
            }
            case 2: {
                return logger.isWarnEnabled();
            }
            case 3: 
            case 4: {
                return logger.isErrorEnabled();
            }
        }
        return logger.isTraceEnabled();
    }

    @Override
    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable cause) {
        if (!this.isEnabled(level)) {
            return;
        }
        switch (level) {
            case 0: {
                logger.debug(message, cause);
                break;
            }
            case 1: {
                logger.info(message, cause);
                break;
            }
            case 2: {
                logger.warn(message, cause);
                break;
            }
            case 3: 
            case 4: {
                logger.error(message, cause);
                break;
            }
            default: {
                logger.trace(message, cause);
            }
        }
    }
}

