/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.sqlservermonitoractivity.sentinels;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.sqlservermonitoractivity.sentinels.ScheduleRdbmsStatementSentinel;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private final AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public void init(Activity.Context context, Activity.Store store) {
        try {
            this.rdbmsStatements(context, store);
            this.scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private void rdbmsStatements(Activity.Context context, Activity.Store store) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(ScheduleRdbmsStatementSentinel.class).withIdentity("ScheduleRdbmsStatementSentinel").build();
        job.getJobDataMap().put("context", (Object)context);
        job.getJobDataMap().put("store", (Object)store);
        this.scheduler.scheduleJob(job, Set.of((CronTrigger)TriggerBuilder.newTrigger().withIdentity("Box#ScheduleRdbmsStatementSentinel").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0/5 * 1/1 * ? *")).build()), true);
    }

    public void stop() {
        try {
            this.scheduler.shutdownSchedules();
        }
        catch (SchedulerException e) {
            Logger.error((Throwable)e);
        }
    }
}

