/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.sqlservermonitoractivity.sentinels;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.cosmos.datahub.measurements.monitoring.RdbmsStatement;
import io.intino.cosmos.datahub.messages.universe.QueryAssertion;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;

public class ScheduleRdbmsStatementSentinel
implements ScheduledTrigger {
    public void execute(JobExecutionContext context) {
        new RDBMSMonitor((Activity.Context)context.getMergedJobDataMap().get((Object)"context"), (Activity.Store)context.getMergedJobDataMap().get((Object)"store")).execute();
    }

    public static class RDBMSMonitor {
        private String url;
        private final Activity.Store store;
        private final Activity.Context context;
        private static final Map<String, String> drivers = Map.of("jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:mysql", "com.mysql.jdbc.Driver", "jdbc:postgresql", "org.postgresql.Driver", "jdbc:sqlite", "org.sqlite.JDBC", "jdbc:redshift", "com.amazon.redshift.jdbc42.Driver");

        public RDBMSMonitor(Activity.Context context, Activity.Store store) {
            this.context = context;
            this.store = store;
            this.url = (String)context.initialConfiguration().get("url");
            if (this.url == null) {
                return;
            }
            if (!this.url.contains("TrustServerCertificate=True")) {
                this.url = this.url + ";TrustServerCertificate=True;";
                this.url = this.url.replace(";;", ";");
            }
            this.loadDriver();
            this.testConnection();
        }

        public boolean testConnection() {
            boolean bl;
            block9: {
                DriverManager.setLoginTimeout(1);
                if (this.url == null) {
                    return false;
                }
                Connection connection = DriverManager.getConnection(this.url);
                try {
                    bl = true;
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        Logger.error((String)e.getMessage());
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        }

        public void execute() {
            if (this.url == null) {
                return;
            }
            this.extractData().forEach(e -> this.context.terminal().publish((Event)e));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public List<RdbmsStatement> extractData() {
            DriverManager.setLoginTimeout(5);
            String query = this.query();
            ArrayList<RdbmsStatement> statements = new ArrayList<RdbmsStatement>();
            try (Connection connection = DriverManager.getConnection(this.url);){
                ArrayList<RdbmsStatement> arrayList;
                block16: {
                    ResultSet result = connection.createStatement().executeQuery(query);
                    try {
                        while (result.next()) {
                            String sp = result.getString("statement_text");
                            if (sp.equals(query)) continue;
                            String spHash = RDBMSMonitor.md5(sp);
                            if (this.store.get(spHash, String.class) == null) {
                                this.context.terminal().publish((Event)this.assertion(sp, spHash));
                            }
                            statements.add(this.measurement(result, spHash));
                        }
                        arrayList = statements;
                        if (result == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return arrayList;
            }
            catch (NoSuchAlgorithmException | SQLException e) {
                Logger.error((Throwable)e);
                return new ArrayList<RdbmsStatement>();
            }
        }

        private QueryAssertion assertion(String sp, String spHash) {
            return (QueryAssertion)new QueryAssertion(this.context.observer() + "." + this.context.hostName() + ".sqlserver", this.context.hostName() + "-" + spHash).query(sp).hash(spHash).container(this.context.hostName()).observer(this.context.observer());
        }

        private RdbmsStatement measurement(ResultSet result, String spHash) throws SQLException {
            return new RdbmsStatement(this.context.hostName() + "|" + spHash).timeCPU(result.getDouble("total_cpu_time")).timeElapsed(result.getDouble("total_time_elapsed")).usageExecutions((double)result.getInt("execution_count")).usageLogicalWrites((double)result.getInt("avg_logical_writes")).usageLogicalReads((double)result.getInt("avg_physical_reads"));
        }

        private static String md5(String sp) throws NoSuchAlgorithmException {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(sp.getBytes(StandardCharsets.UTF_8));
            return String.format("%040x", new BigInteger(1, digest.digest()));
        }

        private String query() {
            String string;
            block8: {
                InputStream s = this.getClass().getResourceAsStream("/sqlserver.stats.sql");
                try {
                    string = new String(s.readAllBytes());
                    if (s == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.error((Throwable)e);
                        return "";
                    }
                }
                s.close();
            }
            return string;
        }

        private void loadDriver() {
            drivers.keySet().stream().filter(this.url::startsWith).findFirst().ifPresentOrElse(k -> {
                try {
                    Class.forName(drivers.get(k));
                }
                catch (ClassNotFoundException e) {
                    Logger.error((Throwable)e);
                }
            }, () -> Logger.error((String)"Driver not found"));
        }
    }
}

