/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.loggingactivity.logging;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.scheduler.directory.DirectorySentinel;
import io.intino.consul.framework.Activity;
import io.intino.consul.loggingactivity.logging.FileLogger;
import io.intino.consul.loggingactivity.logging.LogListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.quartz.SchedulerException;

public class WinFileLogger
implements FileLogger {
    private final Activity.Context context;
    private final Activity.Store store;
    private final Map<String, Integer> logCursors;
    private final Set<File> currentLoggers = new HashSet<File>();
    private final AlexandriaScheduler scheduler;

    public WinFileLogger(AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store) {
        this.scheduler = scheduler;
        this.context = context;
        this.store = store;
        Map tmp = (Map)store.get("log-cursors", new TypeToken<Map<String, Integer>>(){}.getType());
        this.logCursors = tmp == null ? new HashMap() : tmp;
    }

    @Override
    public void log(String id, File log) {
        File targetFile;
        if (this.currentLoggers.contains(log)) {
            return;
        }
        File directory = log.isDirectory() ? log : log.getParentFile();
        File file = targetFile = log.isFile() ? log : null;
        if (!directory.exists() || targetFile != null && !targetFile.exists()) {
            return;
        }
        LogListener listener = new LogListener(this.context, id, directory, targetFile, this.logCursors);
        listener.start();
        try {
            this.scheduler.watchDirectory(id, directory, listener::handle, new DirectorySentinel.Event[]{DirectorySentinel.Event.OnCreate, DirectorySentinel.Event.OnDelete, DirectorySentinel.Event.OnModify});
            this.currentLoggers.add(log);
        }
        catch (SchedulerException e) {
            Logger.error((Throwable)e);
        }
        this.save();
    }

    @Override
    public void stop(String id) {
        this.save();
        this.scheduler.stopSentinel(id);
    }

    @Override
    public void save() {
        this.store.put("log-cursors", this.logCursors);
    }
}

