/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.loggingactivity.logging;

import io.intino.alexandria.Resource;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.directory.DirectorySentinel;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.Terminal;
import io.intino.cosmos.datahub.resources.monitoring.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class LogListener {
    private final Terminal terminal;
    private final String id;
    private final File directory;
    private final File targetFile;
    private final Map<String, Integer> logCursors;

    public LogListener(Activity.Context context, String id, File directory, File targetFile, Map<String, Integer> logCursors) {
        this.terminal = context.terminal();
        this.id = id;
        this.directory = directory;
        this.targetFile = targetFile;
        this.logCursors = logCursors;
    }

    void start() {
        if (this.targetFile == null) {
            Arrays.stream(Objects.requireNonNull(this.directory.listFiles(File::isFile))).filter(f -> f.isFile() && !f.getName().startsWith(".")).filter(f -> !this.logCursors.containsKey(f)).forEach(this::processCompleteLogFile);
        } else if (!this.logCursors.containsKey(this.targetFile.getAbsolutePath())) {
            this.processCompleteLogFile(this.targetFile);
        }
    }

    private void processCompleteLogFile(File file) {
        String content = this.readString(file);
        if (!content.isEmpty()) {
            Logger.debug((String)("Publishing " + file.getName()));
            this.terminal.publish((Event)this.logMessage(file, content));
        }
        this.logCursors.put(file.getAbsolutePath(), content.length());
    }

    public void handle(File file, DirectorySentinel.Event event) {
        if (file.isDirectory()) {
            return;
        }
        if (this.targetFile != null && !file.equals(this.targetFile)) {
            return;
        }
        if (DirectorySentinel.Event.OnModify.equals((Object)event) || DirectorySentinel.Event.OnCreate.equals((Object)event)) {
            this.processEventOf(file);
        } else {
            this.logCursors.remove(file.getAbsolutePath());
        }
    }

    private void processEventOf(File file) {
        String remain;
        Integer cursor = this.logCursors.getOrDefault(file.getAbsolutePath(), 0);
        if ((long)cursor.intValue() > file.length()) {
            cursor = 0;
        }
        if (!(remain = this.readString(file, cursor)).isEmpty()) {
            Logger.debug((String)("Publishing remain " + file.getName()));
            this.terminal.publish((Event)this.logMessage(file, remain));
        }
        this.logCursors.put(file.getAbsolutePath(), cursor + remain.length());
    }

    private Log logMessage(File file, String remain) {
        return new Log(this.id, new Resource(file.getAbsolutePath(), remain.getBytes()));
    }

    private String readString(File file) {
        return this.readString(file, 0);
    }

    private String readString(File file, Integer cursor) {
        String string;
        FileInputStream stream = new FileInputStream(file);
        try {
            stream.skip(cursor.intValue());
            string = new String(stream.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return "";
            }
        }
        stream.close();
        return string;
    }
}

