/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.loggingactivity;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.loggingactivity.logging.WinFileLogger;
import io.intino.consul.terminal.Terminal;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class LoggingActivity
implements Activity {
    public static final String LOG_FILES = "log-files";
    private Activity.Context context;
    private Activity.Store store;
    private Map<String, String> logFiles;
    private WinFileLogger winFileLogger;

    public String id() {
        return "logger";
    }

    public boolean configure(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
        this.logFiles = LoggingActivity.logFilesFrom((String)context.initialConfiguration().get(LOG_FILES));
        this.refreshAppLogs(context);
        return this.checkFilesExists(this.logFiles.values());
    }

    private void refreshAppLogs(Activity.Context context) {
        context.terminal().master().applications().forEach(a -> this.logFiles.putIfAbsent(a.id(), ""));
    }

    public Map<String, String> currentConfiguration() {
        return Map.of(LOG_FILES, Json.toJson(this.logFiles.entrySet().stream().map(e -> new ApplicationLog((String)e.getKey(), (String)e.getValue())).toList()));
    }

    public void onStart() {
        try {
            this.context.terminal().master().addEntityListener(this.appListener());
            AlexandriaScheduler scheduler = new AlexandriaScheduler(this.id() + "-activity");
            this.winFileLogger = new WinFileLogger(scheduler, this.context, this.store);
            this.logFiles.entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).forEach(e -> this.winFileLogger.log(LoggingActivity.masterApp(this.context.terminal(), (String)e.getKey()).get().id(), new File((String)e.getValue())));
            scheduler.startSchedules();
        }
        catch (Throwable e2) {
            Logger.error((Throwable)e2);
        }
    }

    public void onStop() {
        this.logFiles.forEach((app, file) -> this.winFileLogger.stop((String)app));
    }

    private Datamart.EntityListener appListener() {
        return new Datamart.EntityListener(){

            public void onCreate(Entity entity) {
                String type = entity.getDefinition().name();
                if ("Application".equals(type) || "JavaApplication".equals(type)) {
                    LoggingActivity.this.logFiles.putIfAbsent(entity.id(), "");
                }
            }

            public void onUpdate(Entity entity) {
            }

            public void onRemove(Entity entity) {
                String type = entity.getDefinition().name();
                if ("Application".equals(type) || "JavaApplication".equals(type)) {
                    LoggingActivity.this.logFiles.remove(entity.id());
                }
            }
        };
    }

    private static Optional<Application> masterApp(Terminal terminal, String app) {
        return terminal.master().application(a -> a.name().equals(app) || a.id().equals(app));
    }

    private boolean checkFilesExists(Collection<String> logFiles) {
        return logFiles.stream().allMatch(f -> f.isEmpty() || new File((String)f).exists());
    }

    private static Map<String, String> logFilesFrom(String json) {
        if (json == null) {
            return new HashMap<String, String>();
        }
        List tags = (List)Json.fromJson((String)json, (Type)new TypeToken<List<ApplicationLog>>(){}.getType());
        return new ConcurrentHashMap<String, String>(tags.stream().collect(Collectors.toMap(t -> t.application, t -> t.file)));
    }

    public record ApplicationLog(String application, String file) {
    }
}

